"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clusters = clusters;
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  isLoading: false,
  clusterLoadError: null,
  asList: [],
  byName: {},
  allNames: []
};

// Convert an  Array of clusters to an object where
// each key is the cluster name
const mapClustersToNames = clusters => clusters.reduce((byName, cluster) => ({
  ...byName,
  [cluster.name]: cluster
}), {});
const getClustersNames = clusters => clusters.map(cluster => cluster.name);
function clusters(state = initialState, action) {
  const {
    type,
    payload
  } = action;
  switch (type) {
    case _action_types.LOAD_CLUSTERS_START:
      return {
        ...state,
        isLoading: true
      };
    case _action_types.LOAD_CLUSTERS_SUCCESS:
      return {
        asList: [...payload.clusters],
        byName: mapClustersToNames(payload.clusters),
        allNames: getClustersNames(payload.clusters),
        isLoading: false
      };
    case _action_types.REFRESH_CLUSTERS_SUCCESS:
      return {
        asList: [...payload.clusters],
        byName: mapClustersToNames(payload.clusters),
        allNames: getClustersNames(payload.clusters)
      };
    case _action_types.LOAD_CLUSTERS_FAILURE:
      return {
        ...state,
        isLoading: false,
        clusterLoadError: payload.error
      };
    case _action_types.REMOVE_CLUSTERS_FINISH:
      const clustersRemoved = payload;
      const updatedList = Object.keys(state.byName).filter(name => clustersRemoved.indexOf(name) < 0).map(name => state.byName[name]);
      return {
        ...state,
        asList: updatedList,
        byName: mapClustersToNames(updatedList),
        allNames: getClustersNames(updatedList)
      };
    default:
      return state;
  }
}