"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductInterceptServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @internal
 */
class ProductInterceptServerPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "buildVersion", void 0);
    this.logger = initContext.logger.get();
    this.config = initContext.config.get();
    this.buildVersion = initContext.env.packageInfo.version;
  }
  setup(core, {
    cloud
  }) {
    return {};
  }
  start(core, {
    cloud,
    intercepts
  }) {
    if (this.config.enabled) {
      var _intercepts$registerT, _intercepts$registerT2;
      void ((_intercepts$registerT = intercepts.registerTriggerDefinition) === null || _intercepts$registerT === void 0 ? void 0 : _intercepts$registerT.call(intercepts, _constants.TRIGGER_DEF_ID, () => {
        this.logger.debug('Registering global product intercept trigger definition');
        return {
          triggerAfter: this.config.interval
        };
      }));
      void ((_intercepts$registerT2 = intercepts.registerTriggerDefinition) === null || _intercepts$registerT2 === void 0 ? void 0 : _intercepts$registerT2.call(intercepts, `${_constants.UPGRADE_TRIGGER_DEF_PREFIX_ID}:${this.buildVersion}`, () => {
        this.logger.debug('Registering global product upgrade intercept trigger definition');
        return {
          triggerAfter: this.config.upgradeInterceptInterval,
          isRecurrent: false
        };
      }));

      // Register trial intercept only if the trial end date is set and not passed
      if (cloud !== null && cloud !== void 0 && cloud.isInTrial()) {
        var _intercepts$registerT3;
        void ((_intercepts$registerT3 = intercepts.registerTriggerDefinition) === null || _intercepts$registerT3 === void 0 ? void 0 : _intercepts$registerT3.call(intercepts, `${_constants.TRIAL_TRIGGER_DEF_ID}:${this.buildVersion}`, () => {
          this.logger.debug('Registering global product trial intercept trigger definition');
          return {
            triggerAfter: this.config.trialInterceptInterval,
            isRecurrent: false
          };
        }));
      }
    }
    return {};
  }
}
exports.ProductInterceptServerPlugin = ProductInterceptServerPlugin;