"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateEmptyDataMessage = exports.FAIL_ALL_RESULTS = exports.ERROR_ALL_RESULTS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateEmptyDataMessage = agentsResponded => _i18n.i18n.translate('xpack.osquery.results.multipleAgentsResponded', {
  defaultMessage: '{agentsResponded, plural, one {# agent has} other {# agents have}} responded, no osquery data has been reported.',
  values: {
    agentsResponded
  }
});
exports.generateEmptyDataMessage = generateEmptyDataMessage;
const ERROR_ALL_RESULTS = exports.ERROR_ALL_RESULTS = _i18n.i18n.translate('xpack.osquery.results.errorSearchDescription', {
  defaultMessage: `An error has occurred on all results search`
});
const FAIL_ALL_RESULTS = exports.FAIL_ALL_RESULTS = _i18n.i18n.translate('xpack.osquery.results.failSearchDescription', {
  defaultMessage: `Failed to fetch results`
});