"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createModelProviderMock = exports.createModelProviderFactoryMock = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createModelProviderMock = () => {
  return {
    getDefaultModel: jest.fn(),
    getModel: jest.fn(),
    getUsageStats: jest.fn()
  };
};
exports.createModelProviderMock = createModelProviderMock;
const createModelProviderFactoryMock = () => {
  return jest.fn().mockImplementation(() => createModelProviderMock());
};
exports.createModelProviderFactoryMock = createModelProviderFactoryMock;