"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertPersistedDefinition = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertPersistedDefinition = ({
  tool,
  definition,
  context
}) => {
  const {
    id,
    type,
    description,
    tags,
    configuration
  } = tool;
  const {
    request,
    spaceId
  } = context;
  const getDynamicProps = () => {
    return definition.getDynamicProps(configuration, {
      request,
      spaceId
    });
  };
  return {
    id,
    type,
    description,
    tags,
    configuration,
    readonly: false,
    isAvailable: () => {
      // persisted tools are always available atm (space check is done via the persistence client)
      return {
        status: 'available'
      };
    },
    getSchema: async () => {
      const props = await getDynamicProps();
      return props.getSchema();
    },
    getHandler: async () => {
      const props = await getDynamicProps();
      return props.getHandler();
    },
    getLlmDescription: async args => {
      const props = await getDynamicProps();
      return props.getLlmDescription ? props.getLlmDescription(args) : description;
    }
  };
};
exports.convertPersistedDefinition = convertPersistedDefinition;