"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTechnicalPreviewWarning = exports.AGENT_SOCKET_TIMEOUT_MS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTechnicalPreviewWarning = featureName => {
  return `${featureName} is in technical preview and may be changed or removed in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.`;
};

/**
 * Timeout for agentic features
 */
exports.getTechnicalPreviewWarning = getTechnicalPreviewWarning;
const AGENT_SOCKET_TIMEOUT_MS = exports.AGENT_SOCKET_TIMEOUT_MS = 5 * 60 * 1000;