"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToolRegistryResolver = useToolRegistryResolver;
var _react = require("react");
var _tools_form_registry = require("../../components/tools/form/registry/tools_form_registry");
var _use_onechat_service = require("../use_onechat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useToolRegistryResolver() {
  const services = (0, _use_onechat_service.useOnechatServices)();
  return (0, _react.useCallback)(async (data, context, options) => {
    const config = (0, _tools_form_registry.getToolTypeConfig)(data.type);
    const resolver = config.getValidationResolver(services);
    return resolver(data, context, options);
  }, [services]);
}