"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDefaultConnector = useDefaultConnector;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDefaultConnector({
  connectors,
  defaultConnectorId
}) {
  return (0, _react.useMemo)(() => {
    var _connectors$;
    if (connectors.length === 0) {
      return undefined;
    }

    // 1. Try defaultConnectorId (GenAI setting) first
    if (defaultConnectorId && connectors.some(c => c.id === defaultConnectorId)) {
      return defaultConnectorId;
    }

    // 2. If no default, try to find a preconfigured connector (Elastic-managed LLM)
    const preconfiguredConnector = connectors.find(c => c.isPreconfigured);
    if (preconfiguredConnector) {
      return preconfiguredConnector.id;
    }

    // 3. If no preconfigured connector, use the first custom connector
    return (_connectors$ = connectors[0]) === null || _connectors$ === void 0 ? void 0 : _connectors$.id;
  }, [connectors, defaultConnectorId]);
}