"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentEdit = useAgentEdit;
var _react = require("react");
var _reactQuery = require("@kbn/react-query");
var _onechatCommon = require("@kbn/onechat-common");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _use_onechat_service = require("../use_onechat_service");
var _use_agent_by_id = require("./use_agent_by_id");
var _use_tools = require("../tools/use_tools");
var _query_keys = require("../../query_keys");
var _duplicate_name = require("../../utils/duplicate_name");
var _search_param_names = require("../../search_param_names");
var _tool_selection_utils = require("../../utils/tool_selection_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultToolSelection = [{
  tool_ids: [..._onechatCommon.defaultAgentToolIds]
}];
const emptyState = () => ({
  id: '',
  name: '',
  description: '',
  labels: [],
  avatar_color: '',
  avatar_symbol: '',
  configuration: {
    instructions: '',
    tools: defaultToolSelection
  }
});
function useAgentEdit({
  editingAgentId,
  onSaveSuccess,
  onSaveError
}) {
  const [searchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const {
    agentService
  } = (0, _use_onechat_service.useOnechatServices)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const [state, setState] = (0, _react.useState)(emptyState());
  const {
    tools,
    isLoading: toolsLoading,
    error: toolsError
  } = (0, _use_tools.useToolsService)();
  const sourceAgentId = searchParams.get(_search_param_names.searchParamNames.sourceId);
  const isClone = Boolean(!editingAgentId && sourceAgentId);
  const agentId = editingAgentId || sourceAgentId || '';
  const {
    agent,
    isLoading: agentLoading,
    error: agentError
  } = (0, _use_agent_by_id.useOnechatAgentById)(agentId);
  const createMutation = (0, _reactQuery.useMutation)({
    mutationFn: data => agentService.create(data),
    onSuccess: result => {
      queryClient.invalidateQueries({
        queryKey: _query_keys.queryKeys.agentProfiles.all
      });
      onSaveSuccess(result);
    },
    onError: err => {
      onSaveError(err);
    }
  });
  const updateMutation = (0, _reactQuery.useMutation)({
    mutationFn: data => {
      if (!editingAgentId) {
        throw new Error('Agent ID is required for update');
      }
      return agentService.update(agentId, data);
    },
    onSuccess: result => {
      queryClient.invalidateQueries({
        queryKey: _query_keys.queryKeys.agentProfiles.all
      });
      onSaveSuccess(result);
    },
    onError: err => {
      onSaveError(err);
    }
  });
  (0, _react.useEffect)(() => {
    if (!agentId) {
      setState(emptyState());
      return;
    }
    if (agent) {
      const {
        type,
        ...agentState
      } = agent;
      if (isClone) {
        agentState.id = (0, _duplicate_name.duplicateName)(agentState.id);
      }
      setState(agentState);
    }
  }, [agentId, agent, isClone]);
  const submit = (0, _react.useCallback)(async data => {
    const cleanedData = (0, _tool_selection_utils.cleanInvalidToolReferences)(data, tools);
    if (editingAgentId) {
      const {
        id,
        ...updatedAgent
      } = cleanedData;
      await updateMutation.mutateAsync(updatedAgent);
    } else {
      await createMutation.mutateAsync(cleanedData);
    }
  }, [editingAgentId, createMutation, updateMutation, tools]);
  const isLoading = agentId ? agentLoading || toolsLoading : false;
  return {
    state,
    isLoading,
    isSubmitting: createMutation.isLoading || updateMutation.isLoading,
    submit,
    tools,
    error: toolsError || agentError
  };
}