"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizationElement = exports.isTabularDataResult = exports.isResourceResult = exports.isQueryResult = exports.isOtherResult = exports.isErrorResult = exports.ToolResultType = exports.SupportedChartType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ToolResultType = exports.ToolResultType = /*#__PURE__*/function (ToolResultType) {
  ToolResultType["resource"] = "resource";
  ToolResultType["tabularData"] = "tabular_data";
  ToolResultType["query"] = "query";
  ToolResultType["visualization"] = "visualization";
  ToolResultType["other"] = "other";
  ToolResultType["error"] = "error";
  return ToolResultType;
}({});
let SupportedChartType = exports.SupportedChartType = /*#__PURE__*/function (SupportedChartType) {
  SupportedChartType["Metric"] = "metric";
  SupportedChartType["Map"] = "map";
  return SupportedChartType;
}({});
const isResourceResult = result => {
  return result.type === ToolResultType.resource;
};
exports.isResourceResult = isResourceResult;
const isTabularDataResult = result => {
  return result.type === ToolResultType.tabularData;
};
exports.isTabularDataResult = isTabularDataResult;
const isQueryResult = result => {
  return result.type === ToolResultType.query;
};
exports.isQueryResult = isQueryResult;
const isOtherResult = result => {
  return result.type === ToolResultType.other;
};
exports.isOtherResult = isOtherResult;
const isErrorResult = result => {
  return result.type === ToolResultType.error;
};
exports.isErrorResult = isErrorResult;
const visualizationElement = exports.visualizationElement = {
  tagName: 'visualization',
  attributes: {
    toolResultId: 'tool-result-id',
    chartType: 'chart-type'
  }
};