"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.textAttachmentDataSchema = exports.screenContextAttachmentDataSchema = exports.esqlAttachmentDataSchema = exports.AttachmentType = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * List of internal / built-in attachment types.
 *
 * The list is not fixed, as contributors can add their own attachment types.
 */
let AttachmentType = exports.AttachmentType = /*#__PURE__*/function (AttachmentType) {
  AttachmentType["screenContext"] = "screen_context";
  AttachmentType["text"] = "text";
  AttachmentType["esql"] = "esql";
  return AttachmentType;
}({});
const esqlAttachmentDataSchema = exports.esqlAttachmentDataSchema = _zod.z.object({
  query: _zod.z.string(),
  description: _zod.z.string().optional()
});

/**
 * Data for an esql attachment.
 */

const textAttachmentDataSchema = exports.textAttachmentDataSchema = _zod.z.object({
  content: _zod.z.string()
});

/**
 * Data for a text attachment.
 */

const screenContextAttachmentDataSchema = exports.screenContextAttachmentDataSchema = _zod.z.object({
  url: _zod.z.string().optional(),
  app: _zod.z.string().optional(),
  description: _zod.z.string().optional(),
  additional_data: _zod.z.record(_zod.z.string()).optional()
}).refine(data => {
  // at least one of the fields must be present
  return data.url || data.app || data.description || data.additional_data;
});

/**
 * Data for a screen context attachment.
 */