"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSuggestedDashboardsValidRuleTypeId = exports.isSuggestedDashboardsValidPanelType = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("@kbn/lens-plugin/common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUGGESTED_DASHBOARDS_VALID_RULE_TYPE_IDS = [_ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID];
const isSuggestedDashboardsValidRuleTypeId = ruleTypeId => {
  return ruleTypeId !== undefined && Object.values(SUGGESTED_DASHBOARDS_VALID_RULE_TYPE_IDS).includes(ruleTypeId);
};

// When adding a new panel type TS will make sure we update ReferencedPanelAttributes, getPanelIndicesMap and getPanelFieldsMap
exports.isSuggestedDashboardsValidRuleTypeId = isSuggestedDashboardsValidRuleTypeId;
const SUGGESTED_DASHBOARDS_VALID_PANEL_TYPES = [_constants.LENS_CONTENT_TYPE];
const isSuggestedDashboardsValidPanelType = type => {
  return Object.values(SUGGESTED_DASHBOARDS_VALID_PANEL_TYPES).includes(type);
};
exports.isSuggestedDashboardsValidPanelType = isSuggestedDashboardsValidPanelType;
const PANEL_TYPE_TO_ATTR = {
  lens: {}
};