"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rulesRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _server = require("@kbn/rule-registry-plugin/server");
var _create_observability_server_route = require("../create_observability_server_route");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertsDynamicIndexPatternRoute = (0, _create_observability_server_route.createObservabilityServerRoute)({
  endpoint: 'GET /api/observability/rules/alerts/dynamic_index_pattern 2023-10-31',
  security: {
    authz: {
      enabled: false,
      reason: 'This endpoint returns alert index names for a set of registration contexts and has traditionally required no specific authorization'
    }
  },
  options: {
    access: 'public'
  },
  params: t.type({
    query: t.type({
      registrationContexts: t.array(t.string),
      namespace: t.string
    })
  }),
  handler: async ({
    dependencies,
    params
  }) => {
    const {
      namespace,
      registrationContexts
    } = params.query;
    const {
      ruleDataService
    } = dependencies;
    const indexNames = registrationContexts.flatMap(registrationContext => {
      var _ruleDataService$find;
      const indexName = (_ruleDataService$find = ruleDataService.findIndexByName(registrationContext, _server.Dataset.alerts)) === null || _ruleDataService$find === void 0 ? void 0 : _ruleDataService$find.getPrimaryAlias(namespace);
      if (indexName != null) {
        return [indexName];
      } else {
        return [];
      }
    });
    return indexNames;
  }
});
const rulesRouteRepository = exports.rulesRouteRepository = alertsDynamicIndexPatternRoute;