"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMSection = APMSection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _charts = require("@elastic/charts");
var _formatters = require("@elastic/charts/dist/utils/data/formatters");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_date_picker_context = require("../../../../../hooks/use_date_picker_context");
var _section_container = require("../section_container");
var _data_handler = require("../../../../../context/has_data_context/data_handler");
var _use_has_data = require("../../../../../hooks/use_has_data");
var _chart_container = require("../../chart_container/chart_container");
var _styled_stat = require("../../styled_stat/styled_stat");
var _on_brush_end = require("../../../helpers/on_brush_end");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/overview/components/sections/apm/apm_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function formatTpm(value) {
  return (0, _numeral.default)(value).format('0.00a');
}
function formatTpmStat(value) {
  if (!value || value === 0) {
    return '0';
  }
  if (value <= 0.1) {
    return '< 0.1';
  }
  if (value > 1000) {
    return (0, _numeral.default)(value).format('0.00a');
  }
  return (0, _numeral.default)(value).format('0,0.0');
}
function APMSection({
  bucketSize
}) {
  var _hasDataMap$apm;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chartThemes = (0, _public.useChartThemes)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    forceUpdate,
    hasDataMap
  } = (0, _use_has_data.useHasData)();
  const {
    relativeStart,
    relativeEnd,
    absoluteStart,
    absoluteEnd,
    lastUpdated
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const {
    data,
    status
  } = (0, _public.useFetcher)(() => {
    if (bucketSize && absoluteStart && absoluteEnd) {
      var _getDataHandler;
      return (_getDataHandler = (0, _data_handler.getDataHandler)('apm')) === null || _getDataHandler === void 0 ? void 0 : _getDataHandler.fetchData({
        absoluteTime: {
          start: absoluteStart,
          end: absoluteEnd
        },
        relativeTime: {
          start: relativeStart,
          end: relativeEnd
        },
        ...bucketSize
      });
    }
  },
  // `forceUpdate` and `lastUpdated` should trigger a reload

  // eslint-disable-next-line react-hooks/exhaustive-deps
  [bucketSize, relativeStart, relativeEnd, absoluteStart, absoluteEnd, forceUpdate, lastUpdated]);
  if (!((_hasDataMap$apm = hasDataMap.apm) !== null && _hasDataMap$apm !== void 0 && _hasDataMap$apm.hasData)) {
    return null;
  }
  const {
    appLink,
    stats,
    series
  } = data || {};
  const min = _moment.default.utc(absoluteStart).valueOf();
  const max = _moment.default.utc(absoluteEnd).valueOf();
  const formatter = bucketSize !== null && bucketSize !== void 0 && bucketSize.dateFormat ? (0, _formatters.timeFormatter)(bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.dateFormat) : (0, _charts.niceTimeFormatter)([min, max]);
  const isLoading = status === _public.FETCH_STATUS.LOADING;
  return /*#__PURE__*/_react.default.createElement(_section_container.SectionContainer, {
    title: _i18n.i18n.translate('xpack.observability.overview.apm.title', {
      defaultMessage: 'Service inventory'
    }),
    appLink: {
      href: appLink,
      label: _i18n.i18n.translate('xpack.observability.overview.apm.appLink', {
        defaultMessage: 'Show service inventory'
      })
    },
    hasError: status === _public.FETCH_STATUS.FAILURE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_styled_stat.StyledStat, {
    title: (0, _numeral.default)(stats === null || stats === void 0 ? void 0 : stats.services.value).format('0a'),
    description: _i18n.i18n.translate('xpack.observability.overview.apm.services', {
      defaultMessage: 'Service inventory'
    }),
    isLoading: isLoading,
    "data-test-subj": "apmServiceStat",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_styled_stat.StyledStat, {
    title: `${formatTpmStat(stats === null || stats === void 0 ? void 0 : stats.transactions.value)} tpm`,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.observability.overview.apm.throughputTip', {
        defaultMessage: 'Values are calculated for transactions with type "Request" or "page-load". If neither are available, values reflect the top transaction type.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.observability.overview.apm.throughput', {
      defaultMessage: 'Throughput'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignCenter",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 19
      }
    }))),
    isLoading: isLoading
    // color={transactionsColor}
    ,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_chart_container.ChartContainer, {
    isInitialLoad: isLoading && !data,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({
    onBrushEnd: event => (0, _on_brush_end.onBrushEnd)({
      x: event.x,
      history
    })
  }, chartThemes, {
    showLegend: false,
    xDomain: {
      min,
      max
    },
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  })), (series === null || series === void 0 ? void 0 : series.transactions.coordinates) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "transactions",
    name: "Transactions",
    data: series === null || series === void 0 ? void 0 : series.transactions.coordinates,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'x',
    yAccessors: ['y'],
    color: euiTheme.colors.vis.euiColorVis0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    position: _charts.Position.Left,
    gridLine: {
      visible: true
    },
    tickFormat: value => `${formatTpm(value)} tpm`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x-axis",
    position: _charts.Position.Bottom,
    tickFormat: formatter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }))));
}