"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionItem = SuggestionItem;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-search-plugin/public");
var _polished = require("polished");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/rule_kql_filter/autocomplete_field/suggestion_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SuggestionItem(props) {
  const {
    isSelected,
    onClick,
    onMouseEnter,
    onKeyDown,
    suggestion
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const suggestionItemContainerCss = (0, _react2.css)`
    display: flex;
    flex-direction: row;
    font-size: ${euiTheme.font.scale.s};
    height: ${euiTheme.size.xl};
    white-space: nowrap;
    background-color: ${isSelected ? euiTheme.colors.lightestShade : 'transparent'};
  `;
  const suggestionItemFieldCss = (0, _react2.css)`
    align-items: center;
    cursor: pointer;
    display: flex;
    flex-direction: row;
    height: ${euiTheme.size.xl};
    padding: ${euiTheme.size.xs};
  `;
  const suggestionItemIconFieldCss = (0, _react2.css)`
    background-color: ${(0, _polished.transparentize)(0.9, getEuiIconColor(euiTheme, suggestion.type))};
    color: ${getEuiIconColor(euiTheme, suggestion.type)};
    flex: 0 0 auto;
    justify-content: center;
    width: ${euiTheme.size.xl};
  `;
  const suggestionItemTextFieldCss = (0, _react2.css)`
    flex: 2 0 0;
    font-family: ${euiTheme.font.familyCode};
  `;
  const suggestionItemDescriptionFieldCss = (0, _react2.css)`
    flex: 3 0 0;
    p {
      display: inline;
      span {
        font-family: ${euiTheme.font.familyCode};
      }
    }
  `;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: suggestionItemContainerCss,
    onClick: onClick,
    onMouseEnter: onMouseEnter,
    onKeyDown: onKeyDown,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: [suggestionItemFieldCss, suggestionItemIconFieldCss],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: getEuiIconType(suggestion.type),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: [suggestionItemFieldCss, suggestionItemTextFieldCss],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, suggestion.text), /*#__PURE__*/_react.default.createElement("div", {
    css: [suggestionItemFieldCss, suggestionItemDescriptionFieldCss],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, suggestion.description));
}
SuggestionItem.defaultProps = {
  isSelected: false
};
const getEuiIconType = suggestionType => {
  switch (suggestionType) {
    case _public.QuerySuggestionTypes.Field:
      return 'kqlField';
    case _public.QuerySuggestionTypes.Value:
      return 'kqlValue';
    case _public.QuerySuggestionTypes.RecentSearch:
      return 'search';
    case _public.QuerySuggestionTypes.Conjunction:
      return 'kqlSelector';
    case _public.QuerySuggestionTypes.Operator:
      return 'kqlOperand';
    default:
      return 'empty';
  }
};
const getEuiIconColor = (euiTheme, suggestionType) => {
  const palette = (0, _eui.euiPaletteColorBlind)();
  switch (suggestionType) {
    case _public.QuerySuggestionTypes.Field:
      return palette[7];
    case _public.QuerySuggestionTypes.Value:
      return palette[0];
    case _public.QuerySuggestionTypes.Operator:
      return palette[1];
    case _public.QuerySuggestionTypes.Conjunction:
      return palette[2];
    case _public.QuerySuggestionTypes.RecentSearch:
    default:
      return euiTheme.colors.mediumShade;
  }
};