"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UISettings = UISettings;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _inferenceCommon = require("@kbn/inference-common");
var _managementSettingsComponentsFieldRow = require("@kbn/management-settings-components-field-row");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/logs-data-access-plugin/public");
var _use_editable_settings = require("../../../hooks/use_editable_settings");
var _use_app_context = require("../../../hooks/use_app_context");
var _use_kibana = require("../../../hooks/use_kibana");
var _bottom_bar_actions = require("../bottom_bar_actions/bottom_bar_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/observability_ai_assistant_management/public/routes/components/settings_tab/ui_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function UISettings({
  knowledgeBase
}) {
  var _knowledgeBase$status, _capabilities$advance;
  const {
    docLinks,
    settings,
    notifications,
    application: {
      capabilities,
      getUrlForApp
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    config
  } = (0, _use_app_context.useAppContext)();
  const settingsKeys = [_inferenceCommon.aiAnonymizationSettings, _public.aiAssistantSimulatedFunctionCalling, ...((_knowledgeBase$status = knowledgeBase.status.value) !== null && _knowledgeBase$status !== void 0 && _knowledgeBase$status.enabled ? [_public.aiAssistantSearchConnectorIndexPattern] : [])];
  const {
    fields,
    handleFieldChange,
    unsavedChanges,
    saveAll,
    isSaving,
    cleanUnsavedChanges
  } = (0, _use_editable_settings.useEditableSettings)(settingsKeys);
  const canEditAdvancedSettings = (_capabilities$advance = capabilities.advancedSettings) === null || _capabilities$advance === void 0 ? void 0 : _capabilities$advance.save;
  async function handleSave() {
    try {
      await saveAll();
      window.location.reload();
    } catch (e) {
      const error = e;
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.apmSettings.save.error', {
          defaultMessage: 'An error occurred while saving the settings'
        }),
        text: error.message
      });
    }
  }
  const hasInvalidChanges = Object.values(unsavedChanges).some(({
    isInvalid
  }) => isInvalid);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, settingsKeys.map(settingKey => {
    const field = fields[settingKey];
    if (!field) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRowProvider, {
      key: settingKey,
      links: docLinks.links.management,
      showDanger: message => notifications.toasts.addDanger(message),
      validateChange: (key, value) => settings.client.validateValue(key, value),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRow, {
      field: field,
      isSavingEnabled: !!canEditAdvancedSettings,
      onFieldChange: handleFieldChange,
      unsavedChange: unsavedChanges[settingKey],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 13
      }
    }));
  }), config.logSourcesEnabled && /*#__PURE__*/_react.default.createElement(_public2.LogSourcesSettingSynchronisationInfo, {
    isLoading: false,
    logSourcesValue: settings.client.get(_public.aiAssistantLogsIndexPattern),
    getUrlForApp: getUrlForApp,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }), !(0, _lodash.isEmpty)(unsavedChanges) && /*#__PURE__*/_react.default.createElement(_bottom_bar_actions.BottomBarActions, {
    isLoading: isSaving,
    onDiscardChanges: cleanUnsavedChanges,
    onSave: handleSave,
    saveLabel: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settings.saveButton', {
      defaultMessage: 'Save changes'
    }),
    unsavedChangesCount: Object.keys(unsavedChanges).length,
    appTestSubj: "observabilityAiAssistantManagement",
    areChangesInvalid: hasInvalidChanges,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }));
}