"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OBSERVABILITY_AGENT_ID = void 0;
exports.registerObservabilityAgent = registerObservabilityAgent;
var _register_tools = require("../tools/register_tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OBSERVABILITY_AGENT_ID = exports.OBSERVABILITY_AGENT_ID = 'observability.agent';
async function registerObservabilityAgent({
  core,
  plugins,
  logger
}) {
  plugins.onechat.agents.register({
    id: OBSERVABILITY_AGENT_ID,
    name: 'Observability Agent',
    description: 'Agent specialized in logs, metrics, and traces',
    avatar_icon: 'logoObservability',
    configuration: {
      instructions: 'You are an observability specialist agent',
      tools: [{
        tool_ids: _register_tools.OBSERVABILITY_AGENT_TOOL_IDS
      }]
    }
  });
}