"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailStatus = DetailStatus;
var _react = _interopRequireDefault(require("react"));
var _summary_status = require("../../summary_status");
var _format_number = require("../../../lib/format_number");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/logstash/detail_status/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DetailStatus({
  stats
}) {
  const {
    http_address: httpAddress,
    events,
    reloads,
    pipeline,
    queue_type: queueType,
    version,
    uptime
  } = stats;
  const firstMetrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.logstash.detailStatus.transportAddressLabel', {
      defaultMessage: 'Transport Address'
    }),
    value: httpAddress,
    'data-test-subj': 'httpAddress'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.logstash.detailStatus.eventsReceivedLabel', {
      defaultMessage: 'Events Received'
    }),
    value: (0, _format_number.formatMetric)(events.in, '0.[0]a'),
    'data-test-subj': 'eventsIn'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.logstash.detailStatus.eventsEmittedLabel', {
      defaultMessage: 'Events Emitted'
    }),
    value: (0, _format_number.formatMetric)(events.out, '0.[0]a'),
    'data-test-subj': 'eventsOut'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.logstash.detailStatus.configReloadsLabel', {
      defaultMessage: 'Config Reloads'
    }),
    value: reloads.successes,
    'data-test-subj': 'numReloads'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.logstash.detailStatus.pipelineWorkersLabel', {
      defaultMessage: 'Pipeline Workers'
    }),
    value: pipeline.workers,
    'data-test-subj': 'pipelineWorkers'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.logstash.detailStatus.batchSizeLabel', {
      defaultMessage: 'Batch Size'
    }),
    value: pipeline.batch_size,
    'data-test-subj': 'pipelineBatchSize'
  }];
  const lastMetrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.logstash.detailStatus.versionLabel', {
      defaultMessage: 'Version'
    }),
    value: version,
    'data-test-subj': 'version'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.logstash.detailStatus.uptimeLabel', {
      defaultMessage: 'Uptime'
    }),
    value: (0, _format_number.formatMetric)(uptime, 'time_since'),
    'data-test-subj': 'uptime'
  }];

  // make queueType conditional
  const metrics = [...firstMetrics];
  if (queueType) {
    metrics.push({
      label: _i18n.i18n.translate('xpack.monitoring.logstash.detailStatus.queueTypeLabel', {
        defaultMessage: 'Queue Type'
      }),
      value: queueType,
      'data-test-subj': 'queueType'
    });
  }
  metrics.push(...lastMetrics);
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: metrics,
    "data-test-subj": "logstashDetailStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 10
    }
  });
}