"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaInstances = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _enums = require("../../../../common/enums");
var _status = require("../../../alerts/status");
var _external_config_context = require("../../../application/contexts/external_config_context");
var _format_number = require("../../../lib/format_number");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _setup_mode = require("../../../lib/setup_mode");
var _badge = require("../../setup_mode/badge");
var _listing_callout = require("../../setup_mode/listing_callout");
var _status_icon = require("../../status_icon");
var _table = require("../../table");
var _cluster_status = require("../cluster_status");
var _format_last_seen_timestamp = require("../format_last_seen_timestamp");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/kibana/instances/instances.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tableCellSplitNumber = theme => (0, _react2.css)`
  font-size: ${(0, _eui.euiFontSize)(theme, 'm').fontSize};
`;
const getColumns = (setupMode, alerts, dateFormat, staleStatusThresholdSeconds) => {
  const columns = [{
    name: _i18n.i18n.translate('xpack.monitoring.kibana.listing.nameColumnTitle', {
      defaultMessage: 'Name'
    }),
    field: 'name',
    render: (name, kibana) => {
      let setupModeStatus = null;
      if ((0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
        const list = (0, _lodash.get)(setupMode, 'data.byUuid', {});
        const uuid = (0, _lodash.get)(kibana, 'kibana.uuid');
        const status = list[uuid] || {};
        const instance = {
          uuid,
          name: kibana.name
        };
        setupModeStatus = /*#__PURE__*/_react.default.createElement(_badge.SetupModeBadge, {
          setupMode: setupMode,
          status: status,
          instance: instance,
          productName: _constants.KIBANA_SYSTEM_ID,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 76,
            columnNumber: 13
          }
        });
        if (status.isNetNewUser) {
          return /*#__PURE__*/_react.default.createElement("div", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 85,
              columnNumber: 15
            }
          }, name, setupModeStatus);
        }
      }
      return /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/kibana/instances/${kibana.kibana.uuid}`),
        "data-test-subj": `kibanaLink-${name}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 13
        }
      }, name), setupModeStatus);
    }
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.kibana.listing.alertsColumnTitle', {
      defaultMessage: 'Alerts'
    }),
    field: 'alerts_column',
    width: '175px',
    sortable: true,
    render: () => /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
      showBadge: true,
      alerts: alerts,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 21
      }
    })
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.kibana.listing.lastReportedStatusColumnTitle', {
      defaultMessage: 'Last Reported Status'
    }),
    field: 'status',
    render: status => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: statusIconColor(status),
        "data-test-subj": "status",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 11
        }
      }, (0, _lodash.capitalize)(status));
    }
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.kibana.listing.lastSeenColumnTitle', {
      defaultMessage: 'Last Seen'
    }),
    field: 'lastSeenTimestamp',
    render: (lastSeenTimestampRaw, kibana) => {
      const lastSeenTimestamp = prepareLastSeenTimestamp(lastSeenTimestampRaw, dateFormat);
      const staleMessage = _i18n.i18n.translate('xpack.monitoring.kibana.listing.staleStatusTooltip', {
        defaultMessage: "It's been more than {staleStatusThresholdSeconds} seconds since we have heard from this instance.",
        values: {
          staleStatusThresholdSeconds
        }
      });
      return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "lastSeen",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 11
        }
      }, lastSeenTimestamp, kibana.statusIsStale && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        "aria-label": staleMessage,
        content: staleMessage,
        size: "l",
        type: "warning",
        color: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 17
        }
      })));
    }
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.kibana.listing.loadAverageColumnTitle', {
      defaultMessage: 'Load Average'
    }),
    field: 'os.load.1m',
    render: value => /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 34
      }
    }, (0, _format_number.formatMetric)(value, '0.00'))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.kibana.listing.memorySizeColumnTitle', {
      defaultMessage: 'Memory Size'
    }),
    field: 'process.memory.resident_set_size_in_bytes',
    render: value => /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 34
      }
    }, (0, _format_number.formatNumber)(value, 'byte'))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.kibana.listing.requestsColumnTitle', {
      defaultMessage: 'Requests'
    }),
    field: 'requests.total',
    render: value => /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 34
      }
    }, (0, _format_number.formatNumber)(value, 'int_commas'))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.kibana.listing.responseTimeColumnTitle', {
      defaultMessage: 'Response Times'
    }),
    // It is possible this does not exist through MB collection
    field: 'response_times.average',
    render: (value, kibana) => {
      var _kibana$response_time;
      if (!value) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 197,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        css: tableCellSplitNumber,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 198,
          columnNumber: 13
        }
      }, (0, _format_number.formatNumber)(value, 'int_commas') + ' ms avg'), /*#__PURE__*/_react.default.createElement("div", {
        css: tableCellSplitNumber,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 13
        }
      }, (0, _format_number.formatNumber)(kibana === null || kibana === void 0 ? void 0 : (_kibana$response_time = kibana.response_times) === null || _kibana$response_time === void 0 ? void 0 : _kibana$response_time.max, 'int_commas'), " ms max"));
    }
  }];
  return columns;
};
const KibanaInstances = props => {
  const {
    clusterStatus,
    alerts,
    setupMode,
    sorting,
    pagination,
    onTableChange
  } = props;
  const {
    staleStatusThresholdSeconds
  } = _react.default.useContext(_external_config_context.ExternalConfigContext);
  const dateFormat = (0, _public.useUiSetting)('dateFormat');
  let setupModeCallOut = null;
  // Merge the instances data with the setup data if enabled
  const instances = props.instances || [];
  if ((0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
    // We want to create a seamless experience for the user by merging in the setup data
    // and the node data from monitoring indices in the likely scenario where some instances
    // are using MB collection and some are using no collection
    const instancesByUuid = instances.reduce((byUuid, instance) => {
      var _instance$kibana$uuid, _instance$kibana;
      return {
        ...byUuid,
        [(_instance$kibana$uuid = (_instance$kibana = instance.kibana) === null || _instance$kibana === void 0 ? void 0 : _instance$kibana.uuid) !== null && _instance$kibana$uuid !== void 0 ? _instance$kibana$uuid : '']: instance
      };
    }, {});
    instances.push(...Object.entries(setupMode.data.byUuid).reduce((_instances, [nodeUuid, instance]) => {
      if (!instancesByUuid[nodeUuid]) {
        _instances.push({
          kibana: {
            ...instance.instance.kibana,
            status: _status_icon.STATUS_ICON_TYPES.GRAY
          }
        });
      }
      return _instances;
    }, []));
    setupModeCallOut = /*#__PURE__*/_react.default.createElement(_listing_callout.ListingCallOut, {
      setupModeData: setupMode.data,
      productName: _constants.KIBANA_SYSTEM_ID,
      customRenderer: () => {
        const customRenderResponse = {
          shouldRender: false,
          componentToRender: null
        };
        const hasInstances = setupMode.data.totalUniqueInstanceCount > 0;
        if (!hasInstances) {
          customRenderResponse.shouldRender = true;
          // @ts-ignore
          customRenderResponse.componentToRender = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 271,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
            announceOnMount: false,
            title: _i18n.i18n.translate('xpack.monitoring.kibana.instances.metricbeatMigration.detectedNodeTitle', {
              defaultMessage: 'Kibana instance detected'
            }),
            color: "warning",
            iconType: "flag",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 272,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 283,
              columnNumber: 19
            }
          }, _i18n.i18n.translate('xpack.monitoring.kibana.instances.metricbeatMigration.detectedNodeDescription', {
            defaultMessage: `The following instances are not monitored.
                        Click 'Monitor with Metricbeat' below to start monitoring.`
          }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
            size: "m",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 293,
              columnNumber: 17
            }
          }));
        }
        return customRenderResponse;
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 7
      }
    });
  }
  const dataFlattened = instances.map(item => {
    var _item$kibana, _item$kibana2;
    return {
      ...item,
      name: (_item$kibana = item.kibana) === null || _item$kibana === void 0 ? void 0 : _item$kibana.name,
      status: (_item$kibana2 = item.kibana) === null || _item$kibana2 === void 0 ? void 0 : _item$kibana2.status
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.kibana.instances.heading",
    defaultMessage: "Kibana instances",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_cluster_status.ClusterStatus, {
    stats: clusterStatus,
    alerts: alerts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 9
    }
  }), setupModeCallOut, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_table.EuiMonitoringTable, {
    "data-test-subj": "kibanaInstancesTable",
    rows: dataFlattened,
    columns: getColumns(setupMode, alerts, dateFormat, staleStatusThresholdSeconds),
    sorting: sorting,
    pagination: pagination,
    setupMode: setupMode,
    productName: _constants.KIBANA_SYSTEM_ID,
    search: {
      box: {
        incremental: true,
        placeholder: _i18n.i18n.translate('xpack.monitoring.kibana.listing.filterInstancesPlaceholder', {
          defaultMessage: 'Filter Instances…'
        })
      }
    },
    onTableChange: onTableChange,
    executeQueryOptions: {
      defaultFields: ['name']
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 11
    }
  }))));
};
exports.KibanaInstances = KibanaInstances;
function statusIconColor(status) {
  switch (status) {
    case 'red':
      return 'danger';
    case 'yellow':
      return 'warning';
    case 'green':
      return 'success';
    default:
      return 'subdued';
  }
}
function prepareLastSeenTimestamp(lastSeenTimestampRaw, dateFormat) {
  const {
    shouldShowRelativeTime,
    formattedTimestamp,
    relativeTime
  } = (0, _format_last_seen_timestamp.formatLastSeenTimestamp)(lastSeenTimestampRaw, dateFormat);
  if (shouldShowRelativeTime) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: formattedTimestamp,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 378,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 379,
        columnNumber: 9
      }
    }, relativeTime));
  }
  return formattedTimestamp;
}