"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPreserveQueryHistory = createPreserveQueryHistory;
var _history = require("history");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function preserveQueryParameters(history, location) {
  location.search = history.location.search;
  return location;
}
function createLocationDescriptorObject(location, state) {
  return typeof location === 'string' ? {
    pathname: location,
    state
  } : location;
}
function createPreserveQueryHistory() {
  const history = (0, _history.createHashHistory)({
    hashType: 'slash'
  });
  const oldPush = history.push;
  const oldReplace = history.replace;
  history.push = (path, state) => oldPush.apply(history, [preserveQueryParameters(history, createLocationDescriptorObject(path, state))]);
  history.replace = (path, state) => oldReplace.apply(history, [preserveQueryParameters(history, createLocationDescriptorObject(path, state))]);
  return history;
}