"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditQueryDelay = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../contexts/kibana");
var _toast_notification_service = require("../../../../services/toast_notification_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/datafeed_chart_flyout/edit_query_delay.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tooltipContent = _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.editQueryDelay.tooltipContent', {
  defaultMessage: 'To edit the query delay, you must have permission to edit the datafeed and the datafeed cannot be running.'
});
const EditQueryDelay = ({
  datafeedId,
  queryDelay,
  isEnabled
}) => {
  const [currentQueryDelay, setCurrentQueryDelay] = (0, _react.useState)(queryDelay);
  const [newQueryDelay, setNewQueryDelay] = (0, _react.useState)();
  const [isEditing, setIsEditing] = (0, _react.useState)(false);
  const {
    updateDatafeed
  } = (0, _kibana.useMlApi)();
  const {
    displaySuccessToast,
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const updateQueryDelay = (0, _react.useCallback)(async () => {
    try {
      await updateDatafeed({
        datafeedId,
        datafeedConfig: {
          query_delay: newQueryDelay
        }
      });
      setCurrentQueryDelay(newQueryDelay);
      displaySuccessToast(_i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.editQueryDelay.changesSavedNotificationMessage', {
        defaultMessage: 'Changes to query delay for {datafeedId} saved',
        values: {
          datafeedId
        }
      }));
    } catch (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.jobsList.datafeedChart.editQueryDelay.changesNotSavedNotificationMessage', {
        defaultMessage: 'Could not save changes to query delay for {datafeedId}',
        values: {
          datafeedId
        }
      }));
    }
    setIsEditing(false);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [datafeedId, newQueryDelay]);
  const editButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    size: "xs",
    isDisabled: isEnabled === false,
    onClick: () => {
      setIsEditing(true);
    },
    iconType: "pencil",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.datafeedChart.queryDelayLinkLabel",
    defaultMessage: "Query delay: {queryDelay}",
    values: {
      queryDelay: newQueryDelay || queryDelay
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }));
  const editButtonWithTooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 33
    }
  }, editButton);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEditing === false ? isEnabled === false ? editButtonWithTooltip : editButton : null, isEditing === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.datafeedChart.queryDelayLabel",
      defaultMessage: "Query delay",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: newQueryDelay || queryDelay
    // @ts-expect-error queryDelay is of type estypes.Duration = string | -1 | 0
    ,
    placeholder: queryDelay,
    onChange: e => {
      setNewQueryDelay(e.target.value);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: newQueryDelay === currentQueryDelay,
    color: "primary",
    size: "xs",
    onClick: updateQueryDelay,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.datafeedChart.applyQueryDelayLabel",
    defaultMessage: "Apply",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    size: "xs",
    onClick: () => setIsEditing(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.datafeedChart.cancelQueryDelayUpdateLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 21
    }
  }))))))) : null);
};
exports.EditQueryDelay = EditQueryDelay;