"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isClassificationFeatureImportanceBaseline = isClassificationFeatureImportanceBaseline;
exports.isClassificationTotalFeatureImportance = isClassificationTotalFeatureImportance;
exports.isRegressionFeatureImportanceBaseline = isRegressionFeatureImportanceBaseline;
exports.isRegressionTotalFeatureImportance = isRegressionTotalFeatureImportance;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Union type for ES result feature importance class name
 */

/**
 * ES result class feature importance
 */

/**
 * ES result feature importance interface
 * TODO We should separate the interface because classes/importance
 * isn't both optional but either/or.
 */

/**
 * ES result top class interface
 */

/**
 * Array of TopClass
 */

/**
 * ES result for class feature importance summary
 */

/**
 * ES result classification total feature importance
 */

/**
 * ES result regression feature importance summary
 */

/**
 * ES result for regression total feature importance
 */

/**
 * Union type of total feature importance types
 */

/**
 * Baseline interface for ES result feature importance class
 */

/**
 * Baseline interface for ES result classification feature importance
 */

/**
 * Baseline interface for ES result regression feature importance
 */

/**
 * Union type of feature importance baseline types
 */

/**
 * Type guard for total feature importance
 *
 * @param {unknown} arg The feature importance to identify
 * @returns {arg is ClassificationTotalFeatureImportance}
 */
function isClassificationTotalFeatureImportance(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['classes']) && Array.isArray(arg.classes);
}

/**
 * Type guard for regression total feature importance
 *
 * @param {unknown} arg The feature importance to identify
 * @returns {arg is RegressionTotalFeatureImportance}
 */
function isRegressionTotalFeatureImportance(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['importance']);
}

/**
 * Type guard for classification feature importance baseline
 *
 * @param {unknown} arg The baseline to identify
 * @returns {arg is ClassificationFeatureImportanceBaseline}
 */
function isClassificationFeatureImportanceBaseline(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['classes']) && Array.isArray(arg.classes);
}

/**
 * Type guard for regression feature importance baseline
 *
 * @param {unknown} arg The baseline to identify
 * @returns {arg is RegressionFeatureImportanceBaseline}
 */
function isRegressionFeatureImportanceBaseline(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['baseline']);
}