"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mlEntityFieldValueSchema = exports.mlEntityFieldSchema = exports.influencerSchema = exports.criteriaFieldSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _anomaly_utils = require("./anomaly_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mlEntityFieldTypeSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_anomaly_utils.ML_ENTITY_FIELD_TYPE.BY), _configSchema.schema.literal(_anomaly_utils.ML_ENTITY_FIELD_TYPE.OVER), _configSchema.schema.literal(_anomaly_utils.ML_ENTITY_FIELD_TYPE.PARTITION)]);
const mlEntityFieldOperationSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_anomaly_utils.ML_ENTITY_FIELD_OPERATIONS.ADD), _configSchema.schema.literal(_anomaly_utils.ML_ENTITY_FIELD_OPERATIONS.REMOVE)]);
const influencerSchema = exports.influencerSchema = _configSchema.schema.object({
  fieldName: _configSchema.schema.string(),
  fieldValue: _configSchema.schema.any()
});
const criteriaFieldSchema = exports.criteriaFieldSchema = _configSchema.schema.object({
  fieldName: _configSchema.schema.string(),
  fieldValue: _configSchema.schema.any(),
  fieldType: _configSchema.schema.maybe(mlEntityFieldTypeSchema)
});
const mlEntityFieldValueSchema = exports.mlEntityFieldValueSchema = _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()]);
const mlEntityFieldSchema = exports.mlEntityFieldSchema = _configSchema.schema.object({
  fieldName: _configSchema.schema.string(),
  fieldValue: _configSchema.schema.maybe(mlEntityFieldValueSchema),
  fieldType: _configSchema.schema.maybe(mlEntityFieldTypeSchema),
  operation: _configSchema.schema.maybe(mlEntityFieldOperationSchema),
  cardinality: _configSchema.schema.maybe(_configSchema.schema.number())
});