"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.init = void 0;
var _constants = require("../../../shared/charts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const init = formulas => {
  var _formulas$get$label, _formulas$get$label2;
  const rxTx = {
    id: 'rxTx',
    chartType: 'xy',
    title: _constants.NETWORK_LABEL,
    layers: [{
      seriesType: 'area',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [{
        ...formulas.get('rx'),
        label: _constants.RX_LABEL
      }, {
        ...formulas.get('tx'),
        label: _constants.TX_LABEL
      }]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    ..._constants.DEFAULT_XY_LEGEND,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const rx = {
    id: 'rx',
    chartType: 'xy',
    title: (_formulas$get$label = formulas.get('rx').label) !== null && _formulas$get$label !== void 0 ? _formulas$get$label : '',
    layers: [{
      seriesType: 'line',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [formulas.get('rx')]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  const tx = {
    id: 'tx',
    chartType: 'xy',
    title: (_formulas$get$label2 = formulas.get('tx').label) !== null && _formulas$get$label2 !== void 0 ? _formulas$get$label2 : '',
    layers: [{
      seriesType: 'line',
      type: 'series',
      xAxis: '@timestamp',
      yAxis: [formulas.get('tx')]
    }],
    ..._constants.DEFAULT_XY_FITTING_FUNCTION,
    ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
    ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
  };
  return {
    xy: {
      rxTx,
      rx,
      tx
    }
  };
};
exports.init = init;