"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.vectorStyleSchema = exports.vectorStylePropertiesSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../../../../../common");
var _constants = require("../../../../../../common/constants");
var _color_schemas = require("./color_schemas");
var _label_schemas = require("./label_schemas");
var _marker_schemas = require("./marker_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const vectorStylePropertiesSchema = exports.vectorStylePropertiesSchema = _configSchema.schema.object({
  [_common.VECTOR_STYLES.SYMBOLIZE_AS]: _configSchema.schema.maybe(_marker_schemas.symbolizeAsSchema),
  [_common.VECTOR_STYLES.FILL_COLOR]: _configSchema.schema.maybe(_color_schemas.fillColorSchema),
  [_common.VECTOR_STYLES.LINE_COLOR]: _configSchema.schema.maybe(_color_schemas.lineColorSchema),
  [_common.VECTOR_STYLES.LINE_WIDTH]: _configSchema.schema.maybe(_marker_schemas.lineWidthSchema),
  [_common.VECTOR_STYLES.ICON]: _configSchema.schema.maybe(_marker_schemas.iconSchema),
  [_common.VECTOR_STYLES.ICON_SIZE]: _configSchema.schema.maybe(_marker_schemas.iconSizeSchema),
  [_common.VECTOR_STYLES.ICON_ORIENTATION]: _configSchema.schema.maybe(_marker_schemas.orientationSchema),
  [_common.VECTOR_STYLES.LABEL_TEXT]: _configSchema.schema.maybe(_label_schemas.labelSchema),
  [_common.VECTOR_STYLES.LABEL_ZOOM_RANGE]: _configSchema.schema.maybe(_label_schemas.labelZoomRangeSchema),
  [_common.VECTOR_STYLES.LABEL_COLOR]: _configSchema.schema.maybe(_color_schemas.labelColorSchema),
  [_common.VECTOR_STYLES.LABEL_SIZE]: _configSchema.schema.maybe(_marker_schemas.labelSizeSchema),
  [_common.VECTOR_STYLES.LABEL_BORDER_COLOR]: _configSchema.schema.maybe(_color_schemas.labelBorderColorSchema),
  [_common.VECTOR_STYLES.LABEL_BORDER_SIZE]: _configSchema.schema.maybe(_label_schemas.labelBorderSizeSchema),
  [_common.VECTOR_STYLES.LABEL_POSITION]: _configSchema.schema.maybe(_label_schemas.labelPositionSchema)
});
const vectorStyleSchema = exports.vectorStyleSchema = _configSchema.schema.object({
  properties: vectorStylePropertiesSchema,
  isTimeAware: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: true,
    meta: {
      description: 'Set to true to apply global time to style metadata requests. When set to true, style metadata will be re-fetched when global time changes.'
    }
  })),
  type: _configSchema.schema.literal(_constants.LAYER_STYLE_TYPE.VECTOR)
});