"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMapsLink = void 0;
var _uuid = require("uuid");
var _kibana_services = require("../kibana_services");
var _constants = require("../../common/constants");
var _locator_definition = require("../locators/map_locator/locator_definition");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMapsLink = async context => {
  var _context$contextualFi;
  const dataView = await (0, _kibana_services.getIndexPatternService)().get(context.dataViewSpec.id);
  // create initial layer descriptor
  const hasTooltips = (context === null || context === void 0 ? void 0 : (_context$contextualFi = context.contextualFields) === null || _context$contextualFi === void 0 ? void 0 : _context$contextualFi.length) && (context === null || context === void 0 ? void 0 : context.contextualFields[0]) !== '_source';
  const initialLayers = [{
    id: (0, _uuid.v4)(),
    visible: true,
    type: _constants.LAYER_TYPE.MVT_VECTOR,
    sourceDescriptor: {
      id: (0, _uuid.v4)(),
      type: _constants.SOURCE_TYPES.ES_SEARCH,
      tooltipProperties: hasTooltips ? context.contextualFields : [],
      label: dataView.getIndexPattern(),
      indexPatternId: context.dataViewSpec.id,
      geoField: context.fieldName,
      scalingType: _constants.SCALING_TYPES.MVT
    }
  }];
  const locator = (0, _kibana_services.getShareService)().url.locators.get(_locator_definition.MAPS_APP_LOCATOR);
  const location = await locator.getLocation({
    filters: (0, _kibana_services.getData)().query.filterManager.getFilters(),
    query: (0, _kibana_services.getData)().query.queryString.getQuery(),
    initialLayers: initialLayers,
    timeRange: (0, _kibana_services.getData)().query.timefilter.timefilter.getTime(),
    dataViewSpec: context.dataViewSpec
  });
  return location;
};
exports.getMapsLink = getMapsLink;