"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetViewControl = void 0;
var _reactRedux = require("react-redux");
var _set_view_control = require("./set_view_control");
var _actions = require("../../../actions");
var _map_selectors = require("../../../selectors/map_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    settings: (0, _map_selectors.getMapSettings)(state),
    zoom: (0, _map_selectors.getMapZoom)(state),
    center: (0, _map_selectors.getMapCenter)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    onSubmit: ({
      lat,
      lon,
      zoom
    }) => {
      dispatch((0, _actions.setGotoWithCenter)({
        lat,
        lon,
        zoom
      }));
    }
  };
}
const connectedSetViewControl = exports.SetViewControl = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_set_view_control.SetViewControl);