"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttributionPopover = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _panel_strings = require("../../panel_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/edit_layer_panel/layer_settings/attribution_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class AttributionPopover extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false,
      label: this.props.label,
      url: this.props.url
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_onApply", () => {
      this.props.onChange({
        label: this.state.label,
        url: this.state.url
      });
      this._closePopover();
    });
    (0, _defineProperty2.default)(this, "_onLabelChange", event => {
      this.setState({
        label: event.target.value
      });
    });
    (0, _defineProperty2.default)(this, "_onUrlChange", event => {
      this.setState({
        url: event.target.value
      });
    });
  }
  _renderPopoverButton() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      className: this.props.popoverButtonClassName,
      "aria-label": this.props.popoverButtonAriaLabel,
      onClick: this._togglePopover,
      size: "xs",
      iconType: this.props.popoverButtonIcon,
      flush: "left",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 7
      }
    }, this.props.popoverButtonLabel);
  }
  _renderContent() {
    const isComplete = this.state.label.length !== 0 && this.state.url.length !== 0;
    const hasChanges = this.state.label !== this.props.label || this.state.url !== this.props.url;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "mapAttributionPopover",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.attribution.attributionFormLabel",
      defaultMessage: "Attribution",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.attribution.labelFieldLabel', {
        defaultMessage: 'Label'
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      compressed: true,
      fullWidth: true,
      value: this.state.label,
      onChange: this._onLabelChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.attribution.urlLabel', {
        defaultMessage: 'Link'
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      compressed: true,
      fullWidth: true,
      value: this.state.url,
      onChange: this._onUrlChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "right",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      isDisabled: !isComplete || !hasChanges,
      onClick: this._onApply,
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 13
      }
    }, _panel_strings.panelStrings.apply))));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "attributionPopover",
      panelPaddingSize: "s",
      anchorPosition: "leftCenter",
      button: this._renderPopoverButton(),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      ownFocus: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 7
      }
    }, this._renderContent());
  }
}
exports.AttributionPopover = AttributionPopover;