"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _contants = require("../common/contants");
var _locator = require("../common/locator");
var _management_sections_service = require("./management_sections_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class ManagementPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "managementSections", new _management_sections_service.ManagementSectionsService());
    (0, _defineProperty2.default)(this, "appUpdater", new _rxjs.BehaviorSubject(() => {
      const deepLinks = Object.values(this.managementSections.definedSections).map(section => ({
        id: section.id,
        title: section.title,
        deepLinks: section.getAppsEnabled().filter(mgmtApp => !mgmtApp.hideFromGlobalSearch).map(mgmtApp => ({
          id: mgmtApp.id,
          title: mgmtApp.title,
          path: mgmtApp.basePath,
          keywords: mgmtApp.keywords
        }))
      }));
      return {
        deepLinks
      };
    }));
    (0, _defineProperty2.default)(this, "hasAnyEnabledApps", true);
    (0, _defineProperty2.default)(this, "isSidebarEnabled$", new _rxjs.BehaviorSubject(true));
    (0, _defineProperty2.default)(this, "cardsNavigationConfig$", new _rxjs.BehaviorSubject({
      enabled: false,
      hideLinksTo: [],
      extendCardNavDefinitions: {}
    }));
    this.initializerContext = initializerContext;
  }
  setup(core, {
    home,
    share,
    cloud
  }) {
    const kibanaVersion = this.initializerContext.env.packageInfo.version;
    const locator = share.url.locators.create(new _locator.ManagementAppLocatorDefinition());
    const managementPlugin = this;
    if (home) {
      home.featureCatalogue.register({
        id: 'stack-management',
        title: _i18n.i18n.translate('management.stackManagement.managementLabel', {
          defaultMessage: 'Stack Management'
        }),
        description: _i18n.i18n.translate('management.stackManagement.managementDescription', {
          defaultMessage: 'Your center console for managing the Elastic Stack.'
        }),
        icon: 'managementApp',
        path: '/app/management',
        showOnHomePage: false,
        category: 'admin',
        visible: () => this.hasAnyEnabledApps
      });
    }
    core.application.register({
      id: _contants.MANAGEMENT_APP_ID,
      title: _i18n.i18n.translate('management.stackManagement.title', {
        defaultMessage: 'Stack Management'
      }),
      order: 9040,
      euiIconType: 'logoElastic',
      category: _public.DEFAULT_APP_CATEGORIES.management,
      updater$: this.appUpdater,
      async mount(params) {
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const [coreStart, deps] = await core.getStartServices();
        const chromeStyle$ = coreStart.chrome.getChromeStyle$();

        // Check if user has enterprise license
        const license = deps.licensing ? await deps.licensing.license$.pipe((0, _rxjs.take)(1)).toPromise() : null;
        const hasEnterpriseLicense = (license === null || license === void 0 ? void 0 : license.hasAtLeast('enterprise')) || false;
        return renderApp(params, {
          sections: (0, _management_sections_service.getSectionsServiceStartPrivate)(),
          kibanaVersion,
          coreStart,
          cloud: deps.cloud,
          hasEnterpriseLicense,
          setBreadcrumbs: newBreadcrumbs => {
            if (deps.serverless) {
              // drop the root management breadcrumb in serverless because it comes from the navigation tree
              const [, ...trailingBreadcrumbs] = newBreadcrumbs;
              deps.serverless.setBreadcrumbs(trailingBreadcrumbs);
            } else {
              coreStart.chrome.setBreadcrumbs(newBreadcrumbs, {
                project: {
                  value: newBreadcrumbs,
                  absolute: true
                }
              });
            }
          },
          isSidebarEnabled$: managementPlugin.isSidebarEnabled$,
          cardsNavigationConfig$: managementPlugin.cardsNavigationConfig$,
          chromeStyle$
        });
      }
    });
    core.getStartServices().then(([coreStart]) => {
      coreStart.chrome.getChromeStyle$().subscribe(style => this.isSidebarEnabled$.next(style === 'classic'));
    });
    return {
      sections: this.managementSections.setup(),
      locator
    };
  }
  start(core, plugins) {
    this.managementSections.start({
      capabilities: core.application.capabilities
    });
    this.hasAnyEnabledApps = (0, _management_sections_service.getSectionsServiceStartPrivate)().getSectionsEnabled().some(section => section.getAppsEnabled().length > 0);
    if (!this.hasAnyEnabledApps) {
      this.appUpdater.next(() => {
        return {
          status: _public.AppStatus.inaccessible,
          visibleIn: []
        };
      });
    }
    return {
      setupCardsNavigation: ({
        enabled,
        hideLinksTo,
        extendCardNavDefinitions
      }) => this.cardsNavigationConfig$.next({
        enabled,
        hideLinksTo,
        extendCardNavDefinitions
      })
    };
  }
}
exports.ManagementPlugin = ManagementPlugin;