"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _common = require("../common");
var _links_content_management_client = require("./content_management/links_content_management_client");
var _kibana_services = require("./services/kibana_services");
var _constants = require("./actions/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class LinksPlugin {
  constructor() {}
  setup(core, plugins) {
    core.getStartServices().then(([_, deps]) => {
      plugins.contentManagement.registry.register({
        id: _common.CONTENT_ID,
        version: {
          latest: _common.LATEST_VERSION
        },
        name: _common.APP_NAME
      });
      plugins.embeddable.registerAddFromLibraryType({
        onAdd: async (container, savedObject) => {
          container.addNewPanel({
            panelType: _common.LINKS_EMBEDDABLE_TYPE,
            serializedState: {
              rawState: {
                savedObjectId: savedObject.id
              }
            }
          }, true);
        },
        savedObjectType: _common.LINKS_SAVED_OBJECT_TYPE,
        savedObjectName: _common.APP_NAME,
        getIconForSavedObject: () => _common.APP_ICON
      });
      plugins.embeddable.registerReactEmbeddableFactory(_common.LINKS_EMBEDDABLE_TYPE, async () => {
        const {
          getLinksEmbeddableFactory
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/links_embeddable')));
        return getLinksEmbeddableFactory();
      });
      plugins.visualizations.registerAlias({
        disableCreate: true,
        // do not allow creation through visualization listing page
        name: _common.CONTENT_ID,
        title: _common.APP_NAME,
        icon: _common.APP_ICON,
        description: _i18n.i18n.translate('links.description', {
          defaultMessage: 'Use links to navigate to commonly used dashboards and websites.'
        }),
        stage: 'production',
        appExtensions: {
          visualizations: {
            docTypes: [_common.CONTENT_ID],
            searchFields: ['title^3'],
            client: _links_content_management_client.getLinksClient,
            toListItem(linkItem) {
              const {
                id,
                type,
                updatedAt,
                attributes
              } = linkItem;
              const {
                title,
                description
              } = attributes;
              return {
                id,
                title,
                editor: {
                  onEdit: async savedObjectId => {
                    const {
                      onVisualizationsEdit
                    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./editor/on_visualizations_edit')));
                    onVisualizationsEdit(savedObjectId);
                  }
                },
                description,
                updatedAt,
                icon: _common.APP_ICON,
                typeTitle: _common.APP_NAME,
                stage: 'production',
                savedObjectType: type
              };
            }
          }
        }
      });
    });
  }
  start(core, plugins) {
    (0, _kibana_services.setKibanaServices)(core, plugins);
    plugins.uiActions.addTriggerActionAsync(_public.ADD_PANEL_TRIGGER, _constants.ADD_LINKS_PANEL_ACTION_ID, async () => {
      const {
        addLinksPanelAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions/add_links_panel_action')));
      return addLinksPanelAction;
    });
    plugins.dashboard.registerDashboardPanelSettings(_common.LINKS_EMBEDDABLE_TYPE, async serializedState => {
      const {
        getPanelPlacement
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/embeddable_module')));
      const placementSettings = await getPanelPlacement(serializedState);
      return {
        placementSettings
      };
    });
    return {};
  }
  stop() {}
}
exports.LinksPlugin = LinksPlugin;