"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensSearchResponseBodySchema = exports.lensSearchRequestQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _content_management = require("../../../../content_management");
var _utils = require("../../../../utils");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO cleanup and align search options types with client side options
// TODO align defaults with cm and other schema definitions (i.e. searchOptionsSchemas)
// TODO See if these should be in body or params?
const lensSearchRequestQuerySchema = exports.lensSearchRequestQuerySchema = _configSchema.schema.object({
  ..._content_management.lensCMSearchOptionsSchema.getPropSchemas(),
  query: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The text to search for Lens visualizations'
    }
  })),
  page: _configSchema.schema.number({
    meta: {
      description: 'Specifies the current page number of the paginated result.'
    },
    min: 1,
    defaultValue: 1
  }),
  perPage: _configSchema.schema.number({
    meta: {
      description: 'Maximum number of Lens visualizations included in a single response'
    },
    defaultValue: 20,
    min: 1,
    max: 1000
  })
});
const lensSearchResponseMetaSchema = _configSchema.schema.object({
  ...(0, _utils.pickFromObjectSchema)(_contentManagementUtils.searchOptionsSchemas, ['page', 'perPage']),
  total: _configSchema.schema.number() // TODO use shared definition
}, {
  unknowns: 'forbid'
});
const lensSearchResponseBodySchema = exports.lensSearchResponseBodySchema = _configSchema.schema.object({
  data: _configSchema.schema.arrayOf(_common.lensResponseItemSchema),
  meta: lensSearchResponseMetaSchema
}, {
  unknowns: 'forbid'
});