"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEmbeddableVariables = getEmbeddableVariables;
exports.isESQLModeEnabled = isESQLModeEnabled;
var _esQuery = require("@kbn/es-query");
var _esqlUtils = require("@kbn/esql-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isESQLModeEnabled({
  uiSettings
}) {
  return uiSettings.get(_esqlUtils.ENABLE_ESQL);
}
function getEmbeddableVariables(query, esqlVariables) {
  if ((0, _esQuery.isOfAggregateQueryType)(query)) {
    const currentVariables = (0, _esqlUtils.getESQLQueryVariables)(query.esql);
    if (!currentVariables.length) {
      return esqlVariables;
    }
    // filter out the variables that are not used in the query
    return esqlVariables.filter(variable => currentVariables.includes(variable.key));
  }
}