"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartSwitchSelectable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _chart_option = require("./chart_option");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/config_panel/chart_switch/chart_switch_selectable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ITEM_HEIGHT = 52;
const MAX_ITEMS_COUNT = 6;
const MAX_LIST_HEIGHT = ITEM_HEIGHT * MAX_ITEMS_COUNT;
function computeListHeight(list) {
  if (list.length > MAX_ITEMS_COUNT) {
    return MAX_LIST_HEIGHT;
  }
}
const ChartSwitchSelectable = ({
  setSearchTerm,
  searchTerm,
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, (0, _extends2.default)({
    singleSelection: true,
    isPreFiltered: true,
    "data-test-subj": "lnsChartSwitchList",
    className: "lnsChartSwitch__options",
    css: (0, _react2.css)`
        width: 384px;
      `,
    height: computeListHeight(props.options),
    searchProps: {
      compressed: true,
      autoFocus: false,
      // focused manually below - see https://github.com/elastic/eui/issues/8287
      inputRef: ref => {
        ref === null || ref === void 0 ? void 0 : ref.focus({
          preventScroll: true
        });
      },
      css: (0, _react2.css)`
          width: 400px;
        `,
      className: 'lnsChartSwitch__search',
      'data-test-subj': 'lnsChartSwitchSearch',
      onChange: setSearchTerm,
      placeholder: _i18n.i18n.translate('xpack.lens.chartSwitch.search', {
        defaultMessage: 'Search visualizations'
      })
    },
    listProps: {
      showIcons: false,
      onFocusBadge: false,
      isVirtualized: false
    },
    renderOption: (option, searchValue) => /*#__PURE__*/_react.default.createElement(_chart_option.ChartOption, {
      option: option,
      searchValue: searchValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }),
    noMatchesMessage: /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
            display: inline;
          `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.chartSwitch.noResults",
      defaultMessage: "No results found for {term}.",
      values: {
        term: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 80,
            columnNumber: 21
          }
        }, searchTerm)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    }))
  }, props, {
    searchable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }), (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, search), list));
};
exports.ChartSwitchSelectable = ChartSwitchSelectable;