"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransformOut = void 0;
var _lensCommon = require("@kbn/lens-common");
var _v = require("../content_management/v1");
var _references = require("../references");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Transform from Lens Serialized State to Lens API format
 */
const getTransformOut = ({
  builder,
  transformEnhancementsOut
}) => {
  return function transformOut(state, references) {
    var _migratedAttributes$v;
    const enhancements = state.enhancements ? transformEnhancementsOut === null || transformEnhancementsOut === void 0 ? void 0 : transformEnhancementsOut(state.enhancements, references !== null && references !== void 0 ? references : []) : undefined;
    const enhancementsState = enhancements ? {
      enhancements
    } : {};
    const savedObjectRef = (0, _utils.findLensReference)(references);
    if (savedObjectRef && (0, _utils.isByRefLensState)(state)) {
      return {
        ...state,
        ...enhancementsState,
        savedObjectId: savedObjectRef.id
      };
    }
    const migratedAttributes = migrateAttributes(state.attributes);
    const injectedState = (0, _references.injectLensReferences)({
      ...state,
      ...enhancementsState,
      attributes: migratedAttributes
    }, references);
    const chartType = builder.getType(migratedAttributes);
    if (!builder.isSupported(chartType)) {
      // TODO: remove this once all formats are supported
      return injectedState;
    }
    const apiConfig = builder.toAPIFormat({
      ...migratedAttributes,
      visualizationType: (_migratedAttributes$v = migratedAttributes.visualizationType) !== null && _migratedAttributes$v !== void 0 ? _migratedAttributes$v : _lensCommon.LENS_UNKNOWN_VIS
    });
    return {
      ...state,
      attributes: apiConfig
    };
  };
};

/**
 * Handles transforming old lens SO in dashboard to v1 Lens SO
 */
exports.getTransformOut = getTransformOut;
function migrateAttributes(attributes) {
  var _attributes$version;
  if (!attributes) {
    throw new Error('Why are attributes undefined?');
  }
  const {
    visualizationType
  } = attributes;
  if (!visualizationType) {
    throw new Error('Missing visualizationType');
  }
  const version = (_attributes$version = attributes.version) !== null && _attributes$version !== void 0 ? _attributes$version : 0;
  let newAttributes = {
    ...attributes
  };
  if (version < _v.LENS_ITEM_VERSION_V1) {
    newAttributes = {
      ...newAttributes,
      ...(0, _v.transformToV1LensItemAttributes)({
        ...attributes,
        visualizationType
      })
    };
  }
  return newAttributes;
}