"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransformIn = void 0;
var _utils = require("@kbn/lens-embeddable-utils/config_builder/utils");
var _constants = require("../constants");
var _references = require("../references");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Transform from Lens API format to Lens Serialized State
 */
const getTransformIn = ({
  builder,
  transformEnhancementsIn
}) => {
  return function transformIn(config) {
    var _transformEnhancement;
    const {
      enhancementsState: enhancements = null,
      enhancementsReferences = []
    } = config.enhancements ? (_transformEnhancement = transformEnhancementsIn === null || transformEnhancementsIn === void 0 ? void 0 : transformEnhancementsIn(config.enhancements)) !== null && _transformEnhancement !== void 0 ? _transformEnhancement : {} : {};
    const enhancementsState = enhancements ? {
      enhancements
    } : {};
    if ((0, _utils2.isByRefLensConfig)(config)) {
      const {
        savedObjectId: id,
        ...rest
      } = config;
      return {
        state: rest,
        ...enhancementsState,
        references: [{
          name: _utils2.LENS_SAVED_OBJECT_REF_NAME,
          type: _constants.DOC_TYPE,
          id: id
        }, ...enhancementsReferences]
      };
    }
    const chartType = builder.getType(config.attributes);
    if (!builder.isSupported(chartType)) {
      const {
        state,
        references
      } = (0, _references.extractLensReferences)(config);
      // TODO: remove this once all formats are supported
      // when not supported, no transform is needed
      return {
        state,
        ...enhancementsState,
        references: [...references, ...enhancementsReferences]
      };
    }
    if (!config.attributes) {
      // Not sure if this is possible
      throw new Error('attributes are missing');
    }
    const attributes = (0, _utils.isLensAPIFormat)(config.attributes) ? builder.fromAPIFormat(config.attributes) : config.attributes;
    const {
      state,
      references
    } = (0, _references.extractLensReferences)({
      ...config,
      attributes
    });
    return {
      state,
      ...enhancementsState,
      references: [...references, ...enhancementsReferences]
    };
  };
};
exports.getTransformIn = getTransformIn;