"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeAllBucketsWithChartDimensionSchema = mergeAllBucketsWithChartDimensionSchema;
exports.mergeAllMetricsWithChartDimensionSchema = mergeAllMetricsWithChartDimensionSchema;
exports.mergeAllMetricsWithChartDimensionSchemaWithRefBasedOps = mergeAllMetricsWithChartDimensionSchemaWithRefBasedOps;
exports.mergeAllMetricsWithChartDimensionSchemaWithTimeBasedAndStaticOps = mergeAllMetricsWithChartDimensionSchemaWithTimeBasedAndStaticOps;
var _configSchema = require("@kbn/config-schema");
var _metric_ops = require("../metric_ops");
var _bucket_ops = require("../bucket_ops");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Best to not use dynamic schema building logic
 * so the possible combinations are declared here explicitly:
 * - metric without ref based ops (eh. gauge/any chart that cannot have a date histogram)
 * - the previous + ref based ops (eh. line chart with date histogram)
 * - the previous + static op (i.e. reference line or gauge min/max/etc...)
 * - bucket operations
 */

function mergeAllMetricsWithChartDimensionSchema(baseSchema) {
  return _configSchema.schema.oneOf([
  // oneOf allows only 12 items
  // so break down metrics based on the type: field-based, reference-based, formula-like
  _configSchema.schema.oneOf([_configSchema.schema.allOf([baseSchema, _metric_ops.countMetricOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.uniqueCountMetricOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.metricOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.sumMetricOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.lastValueOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.percentileOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.percentileRanksOperationSchema])]), _configSchema.schema.oneOf([_configSchema.schema.allOf([baseSchema, _metric_ops.formulaOperationDefinitionSchema])])]);
}
function mergeAllMetricsWithChartDimensionSchemaWithRefBasedOps(baseSchema) {
  return _configSchema.schema.oneOf([
  // oneOf allows only 12 items
  // so break down metrics based on the type: field-based, reference-based, formula-like
  _configSchema.schema.oneOf([_configSchema.schema.allOf([baseSchema, _metric_ops.countMetricOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.uniqueCountMetricOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.metricOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.sumMetricOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.lastValueOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.percentileOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.percentileRanksOperationSchema])]), _configSchema.schema.oneOf([_configSchema.schema.allOf([baseSchema, _metric_ops.differencesOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.movingAverageOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.cumulativeSumOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.counterRateOperationSchema])]), _configSchema.schema.oneOf([_configSchema.schema.allOf([baseSchema, _metric_ops.formulaOperationDefinitionSchema])])]);
}
function mergeAllMetricsWithChartDimensionSchemaWithTimeBasedAndStaticOps(baseSchema) {
  return _configSchema.schema.oneOf([
  // oneOf allows only 12 items
  // so break down metrics based on the type: field-based, reference-based, formula-like
  _configSchema.schema.oneOf([_configSchema.schema.allOf([baseSchema, _metric_ops.countMetricOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.uniqueCountMetricOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.metricOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.sumMetricOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.lastValueOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.percentileOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.percentileRanksOperationSchema])]), _configSchema.schema.oneOf([_configSchema.schema.allOf([baseSchema, _metric_ops.differencesOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.movingAverageOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.cumulativeSumOperationSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.counterRateOperationSchema])]), _configSchema.schema.oneOf([_configSchema.schema.allOf([baseSchema, _metric_ops.staticOperationDefinitionSchema]), _configSchema.schema.allOf([baseSchema, _metric_ops.formulaOperationDefinitionSchema])])]);
}
function mergeAllBucketsWithChartDimensionSchema(baseSchema) {
  return _configSchema.schema.oneOf([_configSchema.schema.allOf([baseSchema, _bucket_ops.bucketDateHistogramOperationSchema]), _configSchema.schema.allOf([baseSchema, _bucket_ops.bucketTermsOperationSchema]), _configSchema.schema.allOf([baseSchema, _bucket_ops.bucketHistogramOperationSchema]), _configSchema.schema.allOf([baseSchema, _bucket_ops.bucketRangesOperationSchema]), _configSchema.schema.allOf([baseSchema, _bucket_ops.bucketFiltersOperationSchema])]);
}