"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildTagCloud = buildTagCloud;
var _types = require("../types");
var _utils = require("../utils");
var _columns = require("../columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACCESSOR = 'metric_formula_accessor';
function getAccessorName(type) {
  return `${ACCESSOR}_${type}`;
}
function buildVisualizationState(config) {
  const layer = config;
  return {
    layerId: _types.DEFAULT_LAYER_ID,
    valueAccessor: ACCESSOR,
    maxFontSize: 72,
    minFontSize: 12,
    orientation: 'single',
    showLabel: true,
    ...(layer.breakdown ? {
      tagAccessor: getAccessorName('breakdown')
    } : {})
  };
}
function buildFormulaLayer(layer, i, dataView) {
  const layers = {
    [_types.DEFAULT_LAYER_ID]: {
      ...(0, _columns.getFormulaColumn)(ACCESSOR, (0, _utils.mapToFormula)(layer), dataView)
    }
  };
  const defaultLayer = layers[_types.DEFAULT_LAYER_ID];
  if (layer.breakdown) {
    const columnName = getAccessorName('breakdown');
    const breakdownColumn = (0, _columns.getBreakdownColumn)({
      options: layer.breakdown,
      dataView
    });
    (0, _utils.addLayerColumn)(defaultLayer, columnName, breakdownColumn, true);
  } else {
    throw new Error('breakdown must be defined on tagcloud!');
  }
  return defaultLayer;
}
function getValueColumns(layer) {
  if (layer.breakdown && typeof layer.breakdown !== 'string') {
    throw new Error('breakdown must be a field name when not using index source');
  }
  return [(0, _columns.getValueColumn)(ACCESSOR, layer.value), (0, _columns.getValueColumn)(getAccessorName('breakdown'), layer.breakdown)];
}
async function buildTagCloud(config, {
  dataViewsAPI
}) {
  const dataviews = {};
  const _buildFormulaLayer = (cfg, i, dataView) => buildFormulaLayer(cfg, i, dataView);
  const datasourceStates = await (0, _utils.buildDatasourceStates)(config, dataviews, _buildFormulaLayer, getValueColumns, dataViewsAPI);
  const {
    references,
    internalReferences,
    adHocDataViews
  } = (0, _utils.extractReferences)(dataviews);
  return {
    title: config.title,
    visualizationType: 'lnsTagcloud',
    references,
    state: {
      datasourceStates,
      internalReferences,
      filters: [],
      query: {
        language: 'kuery',
        query: ''
      },
      visualization: buildVisualizationState(config),
      adHocDataViews
    }
  };
}