"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaPageTemplateSolutionNavAvatar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/kibana_react/public/page_template/solution_nav/solution_nav_avatar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Applies extra styling to a typical EuiAvatar
 */
const KibanaPageTemplateSolutionNavAvatar = ({
  className,
  size,
  ...rest
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const pageTemplateSolutionNavAvatarStyles = {
    base: (0, _react.css)((0, _eui.useEuiShadow)('s')),
    xxl: (0, _react.css)`
      ${(0, _eui.useEuiShadow)('m')};
      width: 100px;
      height: 100px;
      line-height: 100px;
      border-radius: 100px;
      display: inline-block;
      background: ${euiTheme.colors.backgroundBasePlain} url('../../assets/texture.svg') no-repeat;
      background-size: cover, 125%;
      text-align: center;
    `
  };
  return (
    /*#__PURE__*/
    // @ts-expect-error Complains about ExclusiveUnion between `iconSize` and `iconType`, but works fine
    _react2.default.createElement(_eui.EuiAvatar, (0, _extends2.default)({
      className: className,
      css: [pageTemplateSolutionNavAvatarStyles.base, size === 'xxl' && pageTemplateSolutionNavAvatarStyles.xxl],
      color: "plain",
      size: size === 'xxl' ? 'xl' : size,
      iconSize: size
    }, rest, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 5
      }
    }))
  );
};
exports.KibanaPageTemplateSolutionNavAvatar = KibanaPageTemplateSolutionNavAvatar;