"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIconType = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Get the EUI icon type from a HTML element.
 * @param {HTMLElement} element The HTML element to check.
 * @return {string | null} The EUI icon type, or null if not found.
 */
const getIconType = element => {
  var _element$querySelecto;
  return ((_element$querySelecto = element.querySelector('svg')) === null || _element$querySelecto === void 0 ? void 0 : _element$querySelecto.getAttribute(_constants.EUI_DATA_ICON_TYPE)) || null;
};
exports.getIconType = getIconType;