"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initInfraAssetRoutes = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _infra = require("../../../common/http_api/infra");
var _get_infra_alerts_client = require("../../lib/helpers/get_infra_alerts_client");
var _get_hosts = require("./lib/host/get_hosts");
var _get_hosts_count = require("./lib/host/get_hosts_count");
var _get_infra_metrics_client = require("../../lib/helpers/get_infra_metrics_client");
var _get_apm_data_access_client = require("../../lib/helpers/get_apm_data_access_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initInfraAssetRoutes = libs => {
  const {
    framework
  } = libs;
  framework.registerRoute({
    method: 'post',
    path: '/api/metrics/infra/{entityType}',
    validate: {
      body: (0, _ioTsUtils.createRouteValidationFunction)(_infra.GetInfraMetricsRequestBodyPayloadRT),
      params: (0, _ioTsUtils.createRouteValidationFunction)(_infra.GetInfraMetricsRequestParamsRT)
    }
  }, async (context, request, response) => {
    const {
      from,
      to,
      metrics,
      limit,
      query,
      schema
    } = request.body;
    try {
      const apmDataAccessClient = (0, _get_apm_data_access_client.getApmDataAccessClient)({
        request,
        libs,
        context
      });
      const hasApmPrivileges = await apmDataAccessClient.hasPrivileges();
      const [infraMetricsClient, alertsClient, apmDataAccessServices] = await Promise.all([(0, _get_infra_metrics_client.getInfraMetricsClient)({
        request,
        libs,
        context
      }), (0, _get_infra_alerts_client.getInfraAlertsClient)({
        libs,
        request
      }), hasApmPrivileges ? apmDataAccessClient.getServices() : undefined]);
      const hosts = await (0, _get_hosts.getHosts)({
        from,
        to,
        metrics,
        limit,
        query,
        alertsClient,
        infraMetricsClient,
        apmDataAccessServices,
        schema
      });
      return response.ok({
        body: _infra.GetInfraMetricsResponsePayloadRT.encode(hosts)
      });
    } catch (err) {
      var _err$statusCode, _err$message;
      if (_boom.default.isBoom(err)) {
        return response.customError({
          statusCode: err.output.statusCode,
          body: {
            message: err.output.payload.message
          }
        });
      }
      return response.customError({
        statusCode: (_err$statusCode = err.statusCode) !== null && _err$statusCode !== void 0 ? _err$statusCode : 500,
        body: {
          message: (_err$message = err.message) !== null && _err$message !== void 0 ? _err$message : 'An unexpected error occurred'
        }
      });
    }
  });
  framework.registerRoute({
    method: 'post',
    path: '/api/infra/{entityType}/count',
    validate: {
      body: (0, _ioTsUtils.createRouteValidationFunction)(_infra.GetInfraEntityCountRequestBodyPayloadRT),
      params: (0, _ioTsUtils.createRouteValidationFunction)(_infra.GetInfraEntityCountRequestParamsPayloadRT)
    }
  }, async (context, request, response) => {
    const {
      body,
      params
    } = request;
    const {
      entityType
    } = params;
    const {
      query,
      from,
      to,
      schema = 'ecs'
    } = body;
    try {
      const apmDataAccessClient = (0, _get_apm_data_access_client.getApmDataAccessClient)({
        request,
        libs,
        context
      });
      const hasApmPrivileges = await apmDataAccessClient.hasPrivileges();
      const [infraMetricsClient, apmDataAccessServices] = await Promise.all([(0, _get_infra_metrics_client.getInfraMetricsClient)({
        request,
        libs,
        context
      }), hasApmPrivileges ? apmDataAccessClient.getServices() : undefined]);
      const count = await (0, _get_hosts_count.getHostsCount)({
        infraMetricsClient,
        apmDataAccessServices,
        query,
        from,
        to,
        schema
      });
      return response.ok({
        body: _infra.GetInfraEntityCountResponsePayloadRT.encode({
          entityType,
          count
        })
      });
    } catch (err) {
      var _err$statusCode2, _err$message2;
      if (_boom.default.isBoom(err)) {
        return response.customError({
          statusCode: err.output.statusCode,
          body: {
            message: err.output.payload.message
          }
        });
      }
      return response.customError({
        statusCode: (_err$statusCode2 = err.statusCode) !== null && _err$statusCode2 !== void 0 ? _err$statusCode2 : 500,
        body: {
          message: (_err$message2 = err.message) !== null && _err$message2 !== void 0 ? _err$message2 : 'An unexpected error occurred'
        }
      });
    }
  });
};
exports.initInfraAssetRoutes = initInfraAssetRoutes;