"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsTabContent = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _esQuery = require("@kbn/es-query");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../../../../hooks/use_kibana");
var _build = require("../../../../../../utils/filters/build");
var _use_hosts_view = require("../../../hooks/use_hosts_view");
var _use_logs_search_url_state = require("../../../hooks/use_logs_search_url_state");
var _use_unified_search = require("../../../hooks/use_unified_search");
var _logs_search_bar = require("./logs_search_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/tabs/logs/logs_tab_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogsTabContent = () => {
  const {
    services: {
      logsShared: {
        LogsOverview
      },
      uiSettings
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    parsedDateRange,
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const timeRange = (0, _react.useMemo)(() => ({
    start: parsedDateRange.from,
    end: parsedDateRange.to
  }), [parsedDateRange.from, parsedDateRange.to]);
  const {
    hostNodes,
    loading,
    error
  } = (0, _use_hosts_view.useHostsViewContext)();
  const [filterQuery] = (0, _use_logs_search_url_state.useLogsSearchUrlState)();

  // Top search bar filters - these should be highlighted
  // These would be passed to Elasticsearch as well to filter by the logs component,
  // but I don't care because the data is already filtered at that point
  const topSearchFilters = (0, _react.useMemo)(() => {
    var _searchCriteria$query, _searchCriteria$filte, _searchCriteria$panel;
    const hasQuery = searchCriteria === null || searchCriteria === void 0 ? void 0 : (_searchCriteria$query = searchCriteria.query) === null || _searchCriteria$query === void 0 ? void 0 : _searchCriteria$query.query;
    const hasFilters = (searchCriteria === null || searchCriteria === void 0 ? void 0 : (_searchCriteria$filte = searchCriteria.filters) === null || _searchCriteria$filte === void 0 ? void 0 : _searchCriteria$filte.length) > 0;
    const hasPanelFilters = (searchCriteria === null || searchCriteria === void 0 ? void 0 : (_searchCriteria$panel = searchCriteria.panelFilters) === null || _searchCriteria$panel === void 0 ? void 0 : _searchCriteria$panel.length) > 0;
    if (!hasQuery && !hasFilters && !hasPanelFilters) {
      return [];
    }
    try {
      var _searchCriteria$filte2, _searchCriteria$panel2;
      return [(0, _esQuery.buildEsQuery)(undefined, searchCriteria.query, [...((_searchCriteria$filte2 = searchCriteria.filters) !== null && _searchCriteria$filte2 !== void 0 ? _searchCriteria$filte2 : []), ...((_searchCriteria$panel2 = searchCriteria.panelFilters) !== null && _searchCriteria$panel2 !== void 0 ? _searchCriteria$panel2 : [])], (0, _public.getEsQueryConfig)(uiSettings))];
    } catch (err) {
      // Invalid/incomplete query, return empty array to avoid breaking the component
      return [];
    }
  }, [searchCriteria.query, searchCriteria.filters, searchCriteria.panelFilters, uiSettings]);

  // Logs search bar filters - these should be highlighted
  const logsSearchFilters = (0, _react.useMemo)(() => {
    if (!filterQuery || !filterQuery.query) {
      return [];
    }
    try {
      return [(0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(filterQuery.query))];
    } catch (err) {
      // Invalid/incomplete query, return empty array to avoid breaking the component
      return [];
    }
  }, [filterQuery]);

  // Combine all user search filters (from both search bars)
  const documentLogFilters = (0, _react.useMemo)(() => [...topSearchFilters, ...logsSearchFilters], [topSearchFilters, logsSearchFilters]);

  // Host name context filters - these should NOT be highlighted
  const nonHighlightingLogFilters = (0, _react.useMemo)(() => [(0, _esQuery.buildEsQuery)(undefined, [], (0, _build.buildCombinedAssetFilter)({
    field: 'host.name',
    values: hostNodes.map(p => p.name)
  }), (0, _public.getEsQueryConfig)(uiSettings))], [hostNodes, uiSettings]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(LogsOverview.LoadingContent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 12
      }
    });
  } else if (error != null) {
    return /*#__PURE__*/_react.default.createElement(LogsOverview.ErrorContent, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 12
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "m",
      "data-test-subj": "hostsView-logs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_logs_search_bar.LogsSearchBar, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(LogsOverview, {
      documentFilters: documentLogFilters,
      nonHighlightingFilters: nonHighlightingLogFilters,
      timeRange: timeRange,
      height: "60vh",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 11
      }
    })));
  }
};
exports.LogsTabContent = LogsTabContent;