"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataHeader = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _popover = require("../../common/popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/overview/metadata_summary/metadata_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const columnTitles = {
  hostIp: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metadataHostIpHeading', {
    defaultMessage: 'Host IP'
  }),
  hostOsVersion: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metadataHostOsVersionHeading', {
    defaultMessage: 'Host OS version'
  }),
  hostName: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metadataHostNameHeading', {
    defaultMessage: 'Host name'
  }),
  cloudProvider: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metadataCloudProviderHeading', {
    defaultMessage: 'Cloud provider'
  }),
  cloudInstanceId: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metadataCloudInstanceIdHeading', {
    defaultMessage: 'Cloud instance ID'
  }),
  cloudImageId: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metadataCloudImageIdHeading', {
    defaultMessage: 'Cloud image ID'
  }),
  operatingSystem: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metadataOperatingSystemHeading', {
    defaultMessage: 'Operating system'
  }),
  containerId: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metadataContainerIdHeading', {
    defaultMessage: 'Container ID'
  }),
  containerImageName: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metadataContainerImageNameHeading', {
    defaultMessage: 'Container image name'
  }),
  runtime: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metadataRuntimeHeading', {
    defaultMessage: 'Runtime'
  })
};
const MetadataHeader = ({
  metadataValue
}) => {
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiDescriptionListTitle, {
    css: (0, _react.css)`
        white-space: nowrap;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, columnTitles[metadataValue.field]), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_popover.Popover, {
    icon: "info",
    "data-test-subj": "infraAssetDetailsMetadataSummaryPopoverButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }, metadataValue.tooltipLink ? /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.overviewMetadata.tooltip.documentationLabel",
    defaultMessage: "See {documentation} for more details.",
    values: {
      documentation: /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraAssetDetailsTooltipMetadataDocumentationLink",
        href: metadataValue.tooltipLink,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react2.default.createElement("code", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 25
        }
      }, metadataValue.tooltipFieldLabel))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react2.default.createElement("code", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 17
    }
  }, metadataValue.tooltipFieldLabel))))));
};
exports.MetadataHeader = MetadataHeader;