"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deserializeDataStream = deserializeDataStream;
exports.deserializeDataStreamList = deserializeDataStreamList;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function deserializeDataStream(dataStreamFromEs, isLogsdbEnabled, failureStoreSettings) {
  var _failureStore$lifecyc, _failureStore$lifecyc2;
  const {
    name,
    timestamp_field: timeStampField,
    indices,
    generation,
    status,
    template,
    ilm_policy: ilmPolicyName,
    store_size: storageSize,
    store_size_bytes: storageSizeBytes,
    maximum_timestamp: maxTimeStamp,
    metering_size_in_bytes: meteringStorageSizeBytes,
    metering_doc_count: meteringDocsCount,
    _meta,
    privileges,
    hidden,
    lifecycle,
    global_max_retention: globalMaxRetention,
    next_generation_managed_by: nextGenerationManagedBy,
    index_mode: indexMode,
    failure_store: failureStore
  } = dataStreamFromEs;
  const meteringStorageSize = meteringStorageSizeBytes !== undefined ? new _configSchema.ByteSizeValue(meteringStorageSizeBytes).toString() : undefined;

  // Determine failure store status based on cluster settings and data stream configuration
  let failureStoreEnabled = false;

  // Check if data stream name matches any pattern in the cluster setting
  if (failureStoreSettings !== null && failureStoreSettings !== void 0 && failureStoreSettings.enabled) {
    const patterns = Array.isArray(failureStoreSettings.enabled) ? failureStoreSettings.enabled : [failureStoreSettings.enabled];
    const matchesPattern = patterns.some(pattern => {
      const regex = new RegExp(pattern.replace(/\*/g, '.*'));
      return regex.test(name);
    });
    if (matchesPattern) {
      // If matches pattern, enable unless explicitly disabled
      const isExplicitlyDisabled = (failureStore === null || failureStore === void 0 ? void 0 : failureStore.enabled) === false;
      failureStoreEnabled = !isExplicitlyDisabled;
    }
  }

  // If explicitly enabled in data stream config, always enable
  if ((failureStore === null || failureStore === void 0 ? void 0 : failureStore.enabled) === true) {
    failureStoreEnabled = true;
  }
  return {
    name,
    timeStampField,
    indices: indices.map(({
      index_name: indexName,
      index_uuid: indexUuid,
      prefer_ilm: preferILM = false,
      managed_by: managedBy
    }) => ({
      name: indexName,
      uuid: indexUuid,
      preferILM,
      managedBy
    })),
    generation,
    health: status.toLowerCase(),
    // ES typically returns status in all-caps
    indexTemplateName: template,
    ilmPolicyName,
    storageSize,
    storageSizeBytes,
    maxTimeStamp,
    meteringStorageSize,
    meteringStorageSizeBytes,
    meteringDocsCount,
    _meta,
    privileges,
    hidden,
    lifecycle: {
      ...lifecycle,
      globalMaxRetention
    },
    nextGenerationManagedBy,
    failureStoreEnabled,
    failureStoreRetention: {
      // @ts-expect-error
      customRetentionPeriod: (_failureStore$lifecyc = failureStore === null || failureStore === void 0 ? void 0 : (_failureStore$lifecyc2 = failureStore.lifecycle) === null || _failureStore$lifecyc2 === void 0 ? void 0 : _failureStore$lifecyc2.data_retention) !== null && _failureStore$lifecyc !== void 0 ? _failureStore$lifecyc : undefined,
      defaultRetentionPeriod: failureStoreSettings === null || failureStoreSettings === void 0 ? void 0 : failureStoreSettings.defaultRetentionPeriod
    },
    indexMode: indexMode !== null && indexMode !== void 0 ? indexMode : isLogsdbEnabled && /^logs-[^-]+-[^-]+$/.test(name) ? _constants.LOGSDB_INDEX_MODE : _constants.STANDARD_INDEX_MODE
  };
}
function deserializeDataStreamList(dataStreamsFromEs, isLogsdbEnabled, failureStoreSettings) {
  return dataStreamsFromEs.map(dataStream => deserializeDataStream(dataStream, isLogsdbEnabled, failureStoreSettings));
}