"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _shared_imports = require("../../../../shared_imports");
var _components = require("../../../components");
var _api = require("../../../services/api");
var _breadcrumbs = require("../../../services/breadcrumbs");
var _documentation = require("../../../services/documentation");
var _app_context = require("../../../app_context");
var _routing = require("../../../services/routing");
var _index_templates = require("../../../lib/index_templates");
var _components2 = require("../components");
var _template_table = require("./template_table");
var _template_details = require("./template_details");
var _template_table2 = require("./legacy_templates/template_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/template_list/template_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function filterTemplates(templates, types) {
  return templates.filter(template => {
    // Exclude deprecated templates by default, unless 'deprecated' is specified in types
    if (template.deprecated && !types.includes('deprecated')) {
      return false;
    }
    if (template._kbnMeta.type === 'default') {
      return true;
    }
    return types.includes(template._kbnMeta.type);
  });
}
const TemplateList = ({
  match: {
    params: {
      templateName
    }
  },
  location,
  history
}) => {
  const {
    uiMetricService
  } = (0, _app_context.useServices)();
  const {
    core: {
      executionContext
    }
  } = (0, _app_context.useAppContext)();
  const {
    error,
    isLoading,
    data: allTemplates,
    resendRequest: reload
  } = (0, _api.useLoadIndexTemplates)();
  (0, _shared_imports.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'indexManagementIndexTemplatesTab'
  });
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.templates);
  }, []);
  const [filters, setFilters] = (0, _react.useState)({
    managed: {
      name: _i18n.i18n.translate('xpack.idxMgmt.indexTemplatesList.viewManagedTemplateLabel', {
        defaultMessage: 'Managed templates'
      }),
      checked: 'on'
    },
    deprecated: {
      name: _i18n.i18n.translate('xpack.idxMgmt.indexTemplatesList.viewDeprecatedTemplateLabel', {
        defaultMessage: 'Deprecated templates'
      }),
      checked: 'off'
    },
    cloudManaged: {
      name: _i18n.i18n.translate('xpack.idxMgmt.indexTemplatesList.viewCloudManagedTemplateLabel', {
        defaultMessage: 'Cloud-managed templates'
      }),
      checked: 'off'
    },
    system: {
      name: _i18n.i18n.translate('xpack.idxMgmt.indexTemplatesList.viewSystemTemplateLabel', {
        defaultMessage: 'System templates'
      }),
      checked: 'off'
    }
  });
  const filteredTemplates = (0, _react.useMemo)(() => {
    if (!allTemplates) {
      // If templates are not fetched, return empty arrays.
      return {
        templates: [],
        legacyTemplates: []
      };
    }
    const visibleTemplateTypes = Object.entries(filters).filter(([name, _filter]) => _filter.checked === 'on').map(([name]) => name);
    return {
      templates: filterTemplates(allTemplates.templates, visibleTemplateTypes),
      legacyTemplates: filterTemplates(allTemplates.legacyTemplates, visibleTemplateTypes)
    };
  }, [allTemplates, filters]);
  const selectedTemplate = Boolean(templateName) ? {
    name: (0, _shared_imports.attemptToURIDecode)(templateName),
    isLegacy: (0, _index_templates.getIsLegacyFromQueryParams)(location)
  } : null;
  const isTemplateDetailsVisible = selectedTemplate !== null;
  const hasTemplates = allTemplates && (allTemplates.legacyTemplates.length > 0 || allTemplates.templates.length > 0);
  const closeTemplateDetails = () => {
    history.push((0, _routing.getTemplateListLink)());
  };
  const editTemplate = (name, isLegacy) => {
    history.push((0, _routing.getTemplateEditLink)(name, isLegacy));
  };
  const cloneTemplate = (name, isLegacy) => {
    history.push((0, _routing.getTemplateCloneLink)(name, isLegacy));
  };
  const renderHeader = () =>
  /*#__PURE__*/
  // flex-grow: 0 is needed here because the parent element is a flex column and the header would otherwise expand.
  _react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    style: {
      flexGrow: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.home.indexTemplatesDescription",
    defaultMessage: "Use composable index templates to automatically apply settings, mappings, and aliases to indices. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation.documentationService.getTemplatesDocumentationLink(),
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.home.indexTemplatesDescription.learnMoreLinkText', {
        defaultMessage: 'Learn more.'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components2.FilterListButton, {
    filters: filters,
    onChange: setFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    iconType: "refresh",
    onClick: reload,
    "data-test-subj": "reloadButton",
    key: "reloadButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateList.table.reloadTemplatesButtonLabel",
    defaultMessage: "Reload",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  }))));
  const renderTemplatesTable = () => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_template_table.TemplateTable, {
      templates: filteredTemplates.templates,
      reload: reload,
      editTemplate: editTemplate,
      cloneTemplate: cloneTemplate,
      history: history,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 9
      }
    }));
  };
  const renderLegacyTemplatesTable = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.home.legacyIndexTemplatesTitle",
    defaultMessage: "Legacy index templates",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_components.LegacyIndexTemplatesDeprecation, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_template_table2.LegacyTemplateTable, {
    templates: filteredTemplates.legacyTemplates,
    reload: reload,
    editTemplate: editTemplate,
    cloneTemplate: cloneTemplate,
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }));

  // Track this component mounted.
  (0, _react.useEffect)(() => {
    uiMetricService.trackMetric(_analytics.METRIC_TYPE.LOADED, _constants.UIM_TEMPLATE_LIST_LOAD);
  }, [uiMetricService]);
  let content;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexTemplatesList.loadingIndexTemplatesDescription",
      defaultMessage: "Loading templates\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 9
      }
    }));
  } else if (error) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexTemplatesList.loadingIndexTemplatesErrorMessage",
        defaultMessage: "Error loading templates",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 271,
          columnNumber: 11
        }
      }),
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 7
      }
    });
  } else if (!hasTemplates) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "managementApp",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        "data-test-subj": "title",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 284,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexTemplatesList.emptyPrompt.noIndexTemplatesTitle",
        defaultMessage: "Create your first index template",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 285,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 293,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexTemplatesList.emptyPrompt.noIndexTemplatesDescription",
        defaultMessage: "An index template automatically applies settings, mappings, and aliases to new indices.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 294,
          columnNumber: 15
        }
      }))),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _shared_imports.reactRouterNavigate)(history, '/create_template'), {
        fill: true,
        iconType: "plusInCircle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 302,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexTemplatesList.emptyPrompt.createTemplatesButtonLabel",
        defaultMessage: "Create template",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 13
        }
      })),
      "data-test-subj": "emptyPrompt",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 7
      }
    });
  } else {
    content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderHeader(), renderTemplatesTable(), filteredTemplates.legacyTemplates.length > 0 && renderLegacyTemplatesTable(), isTemplateDetailsVisible && /*#__PURE__*/_react.default.createElement(_template_details.TemplateDetails, {
      template: selectedTemplate,
      onClose: closeTemplateDetails,
      editTemplate: editTemplate,
      cloneTemplate: cloneTemplate,
      reload: reload,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 329,
        columnNumber: 11
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "templateList",
    className: _shared_imports.APP_WRAPPER_CLASS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 5
    }
  }, content);
};
exports.TemplateList = TemplateList;