"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkspaceLayoutComponent = exports.WorkspaceLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _react2 = require("@emotion/react");
var _search_bar = require("../search_bar");
var _state_management = require("../../state_management");
var _field_manager = require("../field_manager");
var _workspace_top_nav_menu = require("./workspace_top_nav_menu");
var _guidance_panel = require("../guidance_panel");
var _graph_title = require("../graph_title");
var _control_panel = require("../control_panel");
var _graph_visualization = require("../graph_visualization");
var _style_choices = require("../../helpers/style_choices");
var _url = require("../../services/url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/workspace_layout/workspace_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Each component, which depends on `worksapce`
 * should not be memoized, since it will not get updates.
 * This behaviour should be changed after migrating `worksapce` to redux
 */
const FieldManagerMemoized = /*#__PURE__*/(0, _react.memo)(_field_manager.FieldManager);
const GuidancePanelMemoized = /*#__PURE__*/(0, _react.memo)(_guidance_panel.GuidancePanel);
const WorkspaceLayoutComponent = ({
  renderCounter,
  workspace,
  loading,
  savedWorkspace,
  hasFields,
  overlays,
  workspaceInitialized,
  indexPatternProvider,
  capabilities,
  coreStart,
  graphSavePolicy,
  navigation,
  canEditDrillDownUrls,
  setHeaderActionMenu,
  sharingSavedObjectProps,
  spaces,
  inspect,
  requestAdapter
}) => {
  const [currentIndexPattern, setCurrentIndexPattern] = (0, _react.useState)();
  const [pickerOpen, setPickerOpen] = (0, _react.useState)(false);
  const [mergeCandidates, setMergeCandidates] = (0, _react.useState)([]);
  const [control, setControl] = (0, _react.useState)('none');
  const selectedNode = (0, _react.useRef)(undefined);
  const search = (0, _reactRouterDom.useLocation)().search;
  const urlQuery = new URLSearchParams(search).get('query');

  // savedWorkspace.id gets set to null while saving a copy of an existing
  // workspace, so we need to check for savedWorkspace.isSaving as well
  const isInitialized = Boolean(workspaceInitialized || savedWorkspace.id || savedWorkspace.isSaving);
  const selectSelected = (0, _react.useCallback)(node => {
    selectedNode.current = node;
    setControl('editLabel');
  }, []);
  const onSetControl = (0, _react.useCallback)(newControl => {
    selectedNode.current = undefined;
    setControl(newControl);
  }, []);
  const onIndexPatternChange = (0, _react.useCallback)(indexPattern => setCurrentIndexPattern(indexPattern), []);
  const onOpenFieldPicker = (0, _react.useCallback)(() => {
    setPickerOpen(true);
  }, []);
  const confirmWipeWorkspace = (0, _react.useCallback)((onConfirm, text, options) => {
    if (!hasFields) {
      onConfirm();
      return;
    }
    const confirmModalOptions = {
      confirmButtonText: _i18n.i18n.translate('xpack.graph.leaveWorkspace.confirmButtonLabel', {
        defaultMessage: 'Leave anyway'
      }),
      title: _i18n.i18n.translate('xpack.graph.leaveWorkspace.modalTitle', {
        defaultMessage: 'Unsaved changes'
      }),
      'data-test-subj': 'confirmModal',
      ...options
    };
    overlays.openConfirm(text || _i18n.i18n.translate('xpack.graph.leaveWorkspace.confirmText', {
      defaultMessage: 'If you leave now, you will lose unsaved changes.'
    }), confirmModalOptions).then(isConfirmed => {
      if (isConfirmed) {
        onConfirm();
      }
    });
  }, [hasFields, overlays]);
  const onSetMergeCandidates = (0, _react.useCallback)(terms => setMergeCandidates(terms), []);
  const getLegacyUrlConflictCallout = (0, _react.useCallback)(() => {
    // This function returns a callout component *if* we have encountered a "legacy URL conflict" scenario
    const currentObjectId = savedWorkspace.id;
    if (spaces && (sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.outcome) === 'conflict' && currentObjectId) {
      // We have resolved to one object, but another object has a legacy URL alias associated with this ID/page. We should display a
      // callout with a warning for the user, and provide a way for them to navigate to the other object.
      const otherObjectId = sharingSavedObjectProps === null || sharingSavedObjectProps === void 0 ? void 0 : sharingSavedObjectProps.aliasTargetId; // This is always defined if outcome === 'conflict'
      const otherObjectPath = (0, _url.getEditUrl)(coreStart.http.basePath.prepend, {
        id: otherObjectId
      }) + search;
      return spaces.ui.components.getLegacyUrlConflict({
        objectNoun: _i18n.i18n.translate('xpack.graph.legacyUrlConflict.objectNoun', {
          defaultMessage: 'Graph'
        }),
        currentObjectId,
        otherObjectId,
        otherObjectPath
      });
    }
    return null;
  }, [savedWorkspace.id, sharingSavedObjectProps, spaces, coreStart.http, search]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_workspace_top_nav_menu.WorkspaceTopNavMenu, {
    workspace: workspace,
    savedWorkspace: savedWorkspace,
    graphSavePolicy: graphSavePolicy,
    navigation: navigation,
    capabilities: capabilities,
    inspect: inspect,
    requestAdapter: requestAdapter,
    coreStart: coreStart,
    canEditDrillDownUrls: canEditDrillDownUrls,
    confirmWipeWorkspace: confirmWipeWorkspace,
    setHeaderActionMenu: setHeaderActionMenu,
    isInitialized: isInitialized,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }), isInitialized && /*#__PURE__*/_react.default.createElement(_graph_title.GraphTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 25
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.bar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    isLoading: loading,
    urlQuery: urlQuery,
    currentIndexPattern: currentIndexPattern,
    indexPatternProvider: indexPatternProvider,
    confirmWipeWorkspace: confirmWipeWorkspace,
    onIndexPatternChange: onIndexPatternChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(FieldManagerMemoized, {
    pickerOpen: pickerOpen,
    setPickerOpen: setPickerOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  })), getLegacyUrlConflictCallout(), !isInitialized && /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(GuidancePanelMemoized, {
    onOpenFieldPicker: onOpenFieldPicker,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 11
    }
  })), isInitialized && workspace && /*#__PURE__*/_react.default.createElement("div", {
    id: "GraphSvgContainer",
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.visualization,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_graph_visualization.GraphVisualization, {
    workspace: workspace,
    selectSelected: selectSelected,
    onSetControl: onSetControl,
    onSetMergeCandidates: onSetMergeCandidates,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_control_panel.ControlPanel, {
    renderCounter: renderCounter,
    workspace: workspace,
    control: control,
    selectedNode: selectedNode.current,
    colors: _style_choices.colorChoices,
    mergeCandidates: mergeCandidates,
    selectSelected: selectSelected,
    onSetControl: onSetControl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  })));
};
exports.WorkspaceLayoutComponent = WorkspaceLayoutComponent;
const styles = {
  bar: ({
    euiTheme
  }) => `
    margin: ${euiTheme.size.s};
  `,
  container: ({
    euiTheme
  }) => `
    display: flex;
    flex-direction: column;
    flex: 1;
    position: relative;
    background: ${euiTheme.colors.emptyShade};
  `,
  visualization: (0, _react2.css)({
    flex: 1,
    display: 'flex',
    flexDirection: 'column'
  })
};
const WorkspaceLayout = exports.WorkspaceLayout = (0, _reactRedux.connect)(state => ({
  workspaceInitialized: (0, _state_management.workspaceInitializedSelector)(state),
  hasFields: (0, _state_management.hasFieldsSelector)(state)
}))(WorkspaceLayoutComponent);