"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldEditor = FieldEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactField = require("@kbn/react-field");
var _react2 = require("@emotion/react");
var _style_choices = require("../../helpers/style_choices");
var _helpers = require("../helpers");
var _icon_renderer = require("../icon_renderer");
var _styles = require("../../styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/field_manager/field_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldEditor({
  field: initialField,
  updateFieldProperties,
  selectField,
  deselectField,
  allFields
}) {
  const [open, setOpen] = (0, _react.useState)(false);
  const [currentField, setCurrentField] = (0, _react.useState)(initialField);
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    color,
    hopSize,
    lastValidHopSize,
    icon,
    name: fieldName
  } = currentField;
  const isDisabled = initialField.hopSize === 0;

  // update local field copy if changed from the outside
  (0, _react.useEffect)(() => {
    if (currentField !== initialField) {
      setCurrentField(initialField);
    }
    // this hook only updates on change of the prop
    // it's meant to reset the internal state on changes outside of the component.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [initialField]);

  // In case of cleared field and the user closes the popover, restore the initial field
  (0, _react.useEffect)(() => {
    if (!open) {
      setCurrentField(initialField);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [open]);
  function updateField() {
    const {
      name,
      selected,
      type,
      ...updatableProperties
    } = currentField;
    if (fieldName !== initialField.name) {
      deselectField(initialField.name);
      selectField(fieldName);
    }
    updateFieldProperties({
      fieldName,
      fieldProperties: updatableProperties
    });
    setOpen(false);
  }
  function updateProp(name, value) {
    setCurrentField({
      ...currentField,
      [name]: value
    });
  }
  function toggleDisabledState() {
    updateFieldProperties({
      fieldName: initialField.name,
      fieldProperties: {
        hopSize: isDisabled ? initialField.lastValidHopSize : 0,
        lastValidHopSize: isDisabled ? 0 : initialField.hopSize
      }
    });
    setOpen(false);
  }
  const badgeDescription = isDisabled ? _i18n.i18n.translate('xpack.graph.fieldManager.disabledFieldBadgeDescription', {
    defaultMessage: 'Disabled field {field}: Click to configure. Shift+click to enable',
    values: {
      field: fieldName
    }
  }) : _i18n.i18n.translate('xpack.graph.fieldManager.fieldBadgeDescription', {
    defaultMessage: 'Field {field}: Click to configure. Shift+click to disable',
    values: {
      field: fieldName
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: `graphFieldEditor-${initialField.name}`,
    anchorPosition: "downCenter",
    ownFocus: true,
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: initialField.color,
      iconSide: "right",
      onClickAriaLabel: badgeDescription,
      title: "",
      onClick: e => {
        if (e.shiftKey) {
          toggleDisabledState();
        } else {
          setOpen(true);
        }
      },
      css: [(0, _styles.gphFieldBadgeSizeStyles)(euiThemeContext), {
        ...(isDisabled && (0, _react2.css)({
          '&, &:hover, &:focus, &:not(:disabled):hover, &:not(:disabled):focus': {
            opacity: 0.7,
            textDecoration: 'line-through'
          },
          // Chrome fix for focus: duplicate or Safari will ignore completely the disabled rule
          '&:hover:not(:focus-visible), &:focus:not(:focus-visible)': {
            opacity: 0.7,
            textDecoration: 'line-through'
          }
        }))
      }],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
      icon: initialField.icon,
      css: styles.badgeIcon,
      color: color,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 11
      }
    }), initialField.name),
    isOpen: open,
    closePopover: () => setOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: "root",
    panels: [{
      id: 'root',
      items: [{
        name: _i18n.i18n.translate('xpack.graph.fieldManager.settingsLabel', {
          defaultMessage: 'Edit settings'
        }),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "pencil",
          size: "m",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 184,
            columnNumber: 23
          }
        }),
        panel: 'settings'
      }, {
        name: isDisabled ? _i18n.i18n.translate('xpack.graph.fieldManager.enableFieldLabel', {
          defaultMessage: 'Enable field'
        }) : _i18n.i18n.translate('xpack.graph.fieldManager.disableFieldLabel', {
          defaultMessage: 'Disable field'
        }),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: isDisabled ? 'eye' : 'eyeClosed',
          size: "m",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 195,
            columnNumber: 23
          }
        }),
        onClick: toggleDisabledState,
        toolTipContent: isDisabled ? _i18n.i18n.translate('xpack.graph.fieldManager.enableFieldTooltipContent', {
          defaultMessage: 'Turn on discovery of vertices for this field. You can also Shift+click the field to enable it.'
        }) : _i18n.i18n.translate('xpack.graph.fieldManager.disableFieldTooltipContent', {
          defaultMessage: 'Turn off discovery of vertices for this field. You can also Shift+click the field to disable it.'
        })
      }, {
        name: _i18n.i18n.translate('xpack.graph.fieldManager.deleteFieldLabel', {
          defaultMessage: 'Deselect field'
        }),
        toolTipContent: _i18n.i18n.translate('xpack.graph.fieldManager.deleteFieldTooltipContent', {
          defaultMessage: 'No new vertices for this field will be discovered.  Existing vertices remain in the graph.'
        }),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "trash",
          size: "m",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 218,
            columnNumber: 23
          }
        }),
        onClick: () => {
          deselectField(initialField.name);
          setOpen(false);
        }
      }]
    }, {
      id: 'settings',
      title: _i18n.i18n.translate('xpack.graph.fieldManager.settingsFormTitle', {
        defaultMessage: 'Edit'
      }),
      width: 380,
      initialFocusedItemIndex: -1,
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
        css: styles.displayFrom,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 234,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        display: "columnCompressed",
        label: _i18n.i18n.translate('xpack.graph.fieldManager.fieldLabel', {
          defaultMessage: 'Field'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 235,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        onChange: choices => {
          // when user hits backspace the selection gets cleared, so prevent it from breaking
          const newFieldName = choices.length ? choices[0].value : '';
          updateProp('name', newFieldName);
        },
        singleSelection: {
          asPlainText: true
        },
        isClearable: false,
        options: toOptions(allFields, initialField),
        selectedOptions: [{
          value: currentField.name,
          label: currentField.name,
          type: currentField.type
        }],
        renderOption: (option, searchValue, contentClassName) => {
          const {
            type,
            label
          } = option;
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            className: contentClassName,
            gutterSize: "s",
            alignItems: "center",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 261,
              columnNumber: 25
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: null,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 266,
              columnNumber: 27
            }
          }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
            type: type,
            fill: "none",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 267,
              columnNumber: 29
            }
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 269,
              columnNumber: 27
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
            search: searchValue,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 270,
              columnNumber: 29
            }
          }, label)));
        },
        compressed: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 241,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        display: "columnCompressed",
        label: _i18n.i18n.translate('xpack.graph.fieldManager.colorLabel', {
          defaultMessage: 'Color'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 279,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
        color: color,
        onChange: newColor => {
          updateProp('color', newColor);
        },
        compressed: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 285,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        display: "columnCompressed",
        label: _i18n.i18n.translate('xpack.graph.fieldManager.iconLabel', {
          defaultMessage: 'Icon'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 294,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        fullWidth: true,
        singleSelection: {
          asPlainText: true
        },
        isClearable: false,
        renderOption: (option, searchValue, contentClassName) => {
          const {
            label,
            value
          } = option;
          return /*#__PURE__*/_react.default.createElement("span", {
            className: contentClassName,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 307,
              columnNumber: 25
            }
          }, /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
            icon: value,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 308,
              columnNumber: 27
            }
          }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
            search: searchValue,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 309,
              columnNumber: 27
            }
          }, label));
        },
        options: _style_choices.iconChoices.map(currentIcon => ({
          label: currentIcon.label,
          value: currentIcon
        })),
        selectedOptions: [{
          label: icon.label,
          value: icon
        }],
        onChange: choices => {
          updateProp('icon', choices[0].value);
        },
        compressed: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 300,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        display: "columnCompressed",
        label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.graph.fieldManager.maxTermsPerHopLabel', {
          defaultMessage: 'Terms per hop'
        }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          content: _i18n.i18n.translate('xpack.graph.fieldManager.maxTermsPerHopDescription', {
            defaultMessage: 'Controls the maximum number of terms to return for each search step.'
          }),
          position: "right",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 337,
            columnNumber: 23
          }
        })),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 330,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        step: 1,
        min: 1,
        value: isDisabled ? lastValidHopSize : hopSize,
        onChange: ({
          target: {
            valueAsNumber
          }
        }) => {
          const updatedHopSize = Number.isNaN(valueAsNumber) ? 1 : valueAsNumber;
          updateProp(isDisabled ? 'lastValidHopSize' : 'hopSize', updatedHopSize);
        },
        compressed: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 350,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 362,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        justifyContent: "flexEnd",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 364,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 365,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "s",
        onClick: () => {
          setCurrentField(initialField);
          setOpen(false);
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 366,
          columnNumber: 21
        }
      }, _i18n.i18n.translate('xpack.graph.fieldManager.cancelLabel', {
        defaultMessage: 'Cancel'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 378,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        size: "s",
        fill: true,
        disabled: (0, _helpers.isEqual)(initialField, currentField) || currentField.name === '',
        onClick: updateField,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 379,
          columnNumber: 21
        }
      }, _i18n.i18n.translate('xpack.graph.fieldManager.updateLabel', {
        defaultMessage: 'Save changes'
      })))))
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }));
}
function toOptions(fields, currentField) {
  return fields.filter(field => !field.selected || field === currentField).map(({
    name,
    type
  }) => ({
    label: name,
    value: name,
    type: type
  }));
}
const styles = {
  badgeIcon: ({
    euiTheme
  }) => (0, _react2.css)({
    width: 'auto',
    marginRight: euiTheme.size.xs
  }),
  displayFrom: ({
    euiTheme
  }) => (0, _react2.css)({
    padding: euiTheme.size.s
  })
};