"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _types = require("../../types");
var _api_privileges = require("../../constants/api_privileges");
var _errors = require("../schema/errors");
var _enrollment_settings_handler = require("./enrollment_settings_handler");
var _settings_handler = require("./settings_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = (router, experimentalFeatures) => {
  if (experimentalFeatures.useSpaceAwareness) {
    router.versioned
    // @ts-ignore https://github.com/elastic/kibana/issues/203170
    .get({
      path: _constants2.SETTINGS_API_ROUTES.SPACE_INFO_PATTERN,
      fleetAuthz: authz => {
        // TODO move to kibana authz https://github.com/elastic/kibana/issues/203170
        return authz.fleet.readSettings || authz.integrations.writeIntegrationPolicies || authz.fleet.allAgentPolicies;
      },
      summary: `Get space settings`,
      options: {
        availability: {
          since: '9.1.0',
          stability: 'stable'
        }
      }
    }).addVersion({
      version: _constants.API_VERSIONS.public.v1,
      validate: {
        request: _types.GetSpaceSettingsRequestSchema,
        response: {
          200: {
            description: 'OK: A successful request.',
            body: () => _types.SpaceSettingsResponseSchema
          }
        }
      }
    }, _settings_handler.getSpaceSettingsHandler);
    router.versioned.put({
      path: _constants2.SETTINGS_API_ROUTES.SPACE_UPDATE_PATTERN,
      security: {
        authz: {
          requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL]
        }
      },
      summary: `Create space settings`,
      options: {
        availability: {
          since: '9.1.0',
          stability: 'stable'
        }
      }
    }).addVersion({
      version: _constants.API_VERSIONS.public.v1,
      validate: {
        request: _types.PutSpaceSettingsRequestSchema,
        response: {
          200: {
            description: 'OK: A successful request.',
            body: () => _types.SpaceSettingsResponseSchema
          }
        }
      }
    }, _settings_handler.putSpaceSettingsHandler);
  }
  router.versioned.get({
    path: _constants2.SETTINGS_API_ROUTES.INFO_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.SETTINGS.READ]
      }
    },
    summary: `Get settings`,
    options: {
      tags: ['oas-tag:Fleet internals']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetSettingsRequestSchema,
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => _types.SettingsResponseSchema
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        },
        404: {
          description: 'Not found.',
          body: _errors.notFoundResponse
        }
      }
    }
  }, _settings_handler.getSettingsHandler);
  router.versioned.put({
    path: _constants2.SETTINGS_API_ROUTES.UPDATE_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.SETTINGS.ALL]
      }
    },
    summary: `Update settings`,
    options: {
      tags: ['oas-tag:Fleet internals']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PutSettingsRequestSchema,
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => _types.SettingsResponseSchema
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        },
        404: {
          description: 'Not found.',
          body: _errors.notFoundResponse
        }
      }
    }
  }, _settings_handler.putSettingsHandler);
  router.versioned.get({
    path: _constants2.SETTINGS_API_ROUTES.ENROLLMENT_INFO_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.AGENTS.ALL]
      }
    },
    summary: `Get enrollment settings`,
    options: {
      tags: ['oas-tag:Fleet internals']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetEnrollmentSettingsRequestSchema,
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => _types.GetEnrollmentSettingsResponseSchema
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _enrollment_settings_handler.getEnrollmentSettingsHandler);
};
exports.registerRoutes = registerRoutes;