"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _nodePath = _interopRequireDefault(require("node:path"));
var _agentless_policy = require("../../../common/types/rest_spec/agentless_policy");
var _constants = require("../../../common/constants");
var _errors = require("../schema/errors");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  // Create
  router.versioned
  // @ts-ignore https://github.com/elastic/kibana/issues/203170
  .post({
    path: _constants.AGENTLESS_POLICIES_ROUTES.CREATE_PATTERN,
    summary: 'Create an agentless policy',
    description: 'Create an agentless policy',
    options: {
      tags: ['oas-tag:Fleet agentless policies'],
      availability: {
        since: '9.3.0',
        stability: 'experimental'
      }
    },
    fleetAuthz: {
      integrations: {
        writeIntegrationPolicies: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    options: {
      oasOperationObject: () => _nodePath.default.join(__dirname, 'examples/create_agentless_policies.yaml')
    },
    validate: {
      request: _agentless_policy.CreateAgentlessPolicyRequestSchema,
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => _agentless_policy.CreateAgentlessPolicyResponseSchema
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        },
        409: {
          description: 'A conflict occurred.',
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handler.createAgentlessPolicyHandler);

  // Delete
  router.versioned
  // @ts-ignore https://github.com/elastic/kibana/issues/203170
  .delete({
    path: _constants.AGENTLESS_POLICIES_ROUTES.DELETE_PATTERN,
    summary: 'Delete an agentless policy',
    description: 'Delete an agentless policy',
    options: {
      tags: ['oas-tag:Fleet agentless policies'],
      availability: {
        since: '9.3.0',
        stability: 'experimental'
      }
    },
    fleetAuthz: {
      integrations: {
        writeIntegrationPolicies: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    options: {
      oasOperationObject: () => _nodePath.default.join(__dirname, 'examples/delete_agentless_policies.yaml')
    },
    validate: {
      request: _agentless_policy.DeleteAgentlessPolicyRequestSchema,
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => _agentless_policy.DeleteAgentlessPolicyResponseSchema
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        },
        409: {
          description: 'A conflict occurred.',
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handler.deleteAgentlessPolicyHandler);
};
exports.registerRoutes = registerRoutes;