"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentEnrollmentFlyoutData = useAgentEnrollmentFlyoutData;
var _react = require("react");
var _constants = require("../constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAgentEnrollmentFlyoutData() {
  var _fleetServerPolicySta2;
  const {
    data: agentPoliciesData,
    isInitialRequest: isInitialAgentPolicyRequest,
    isLoading: isLoadingAgentPolicies,
    resendRequest: refreshAgentPolicies
  } = (0, _use_request.useGetAgentPolicies)({
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT
  });
  const {
    data: fleetServerPolicyStatus,
    isInitialRequest: isInitialFleetServerPolicyStatusRequest,
    isLoading: isLoadingFleetServerPolicyStatus,
    resendRequest: refreshFleetServerPolicyStatus
  } = (0, _use_request.useGetEnrollmentSettings)();
  const agentPolicies = (0, _react.useMemo)(() => {
    if (!isLoadingAgentPolicies || !isLoadingFleetServerPolicyStatus) {
      var _fleetServerPolicySta, _agentPoliciesData$it;
      const fleetServerPolicyIds = fleetServerPolicyStatus === null || fleetServerPolicyStatus === void 0 ? void 0 : (_fleetServerPolicySta = fleetServerPolicyStatus.fleet_server) === null || _fleetServerPolicySta === void 0 ? void 0 : _fleetServerPolicySta.policies.map(policy => policy.id);
      return ((_agentPoliciesData$it = agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.items) !== null && _agentPoliciesData$it !== void 0 ? _agentPoliciesData$it : []).filter(policy => !(fleetServerPolicyIds !== null && fleetServerPolicyIds !== void 0 && fleetServerPolicyIds.includes(policy.id)));
    }
    return [];
  }, [isLoadingAgentPolicies, isLoadingFleetServerPolicyStatus, fleetServerPolicyStatus === null || fleetServerPolicyStatus === void 0 ? void 0 : (_fleetServerPolicySta2 = fleetServerPolicyStatus.fleet_server) === null || _fleetServerPolicySta2 === void 0 ? void 0 : _fleetServerPolicySta2.policies, agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.items]);
  const refreshData = () => {
    refreshAgentPolicies();
    refreshFleetServerPolicyStatus();
  };
  return {
    agentPolicies,
    refreshAgentPolicies: refreshData,
    isLoadingInitialAgentPolicies: isInitialAgentPolicyRequest || isInitialFleetServerPolicyStatusRequest,
    isLoadingAgentPolicies: isLoadingAgentPolicies || isLoadingFleetServerPolicyStatus
  };
}