"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableIcon = exports.PackageIcon = exports.CardIcon = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _hooks = require("../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/package_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// when a custom SVG is used the logo is rendered with <img class="euiIcon euiIcon--small">
// this collides with some EuiText (+img) CSS from the EuiIcon component
// which  makes the button large, wide, and poorly layed out
// override those styles until the bug is fixed or we find a better approach
const Icon = (0, _styledComponents.default)(_eui.EuiIcon)`
  width: '16px';
  margin-block-end: unset !important;
`;
const PackageIcon = ({
  packageName,
  integrationName,
  version,
  icons,
  tryApi,
  ...euiIconProps
}) => {
  const iconType = (0, _hooks.usePackageIconType)({
    packageName,
    integrationName,
    version,
    icons,
    tryApi
  });
  // @ts-expect-error loading="lazy" is not supported by EuiIcon
  return /*#__PURE__*/_react.default.createElement(Icon, (0, _extends2.default)({
    size: "s",
    type: iconType
  }, euiIconProps, {
    loading: "lazy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 10
    }
  }));
};
exports.PackageIcon = PackageIcon;
const TableIcon = props => {
  const {
    icons
  } = props;
  if (icons && icons.length === 1 && icons[0].type === 'eui') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({
      type: icons[0].src
    }, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 12
      }
    }));
  } else if (icons && icons.length === 1 && icons[0].type === 'svg') {
    // @ts-expect-error loading="lazy" is not supported by EuiIcon
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({
      type: icons[0].src
    }, props, {
      loading: "lazy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 12
      }
    }));
  } else {
    return /*#__PURE__*/_react.default.createElement(PackageIcon, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 12
      }
    }));
  }
};
exports.TableIcon = TableIcon;
const CardIcon = props => {
  const {
    icons
  } = props;
  if (icons && icons.length === 1 && icons[0].type === 'eui') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({
      size: 'xl',
      type: icons[0].src
    }, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 12
      }
    }));
  } else if (icons && icons.length === 1 && icons[0].type === 'svg') {
    // @ts-expect-error loading="lazy" is not supported by EuiIcon
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({
      size: 'xl',
      type: icons[0].src
    }, props, {
      loading: "lazy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 12
      }
    }));
  } else {
    return /*#__PURE__*/_react.default.createElement(PackageIcon, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 12
      }
    }));
  }
};
exports.CardIcon = CardIcon;